/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.Writable;
import org.locationtech.geowave.core.index.ByteArray;
import org.locationtech.geowave.mapreduce.HadoopWritableSerializationTool;

public class AdapterWithObjectWritable
implements Writable {
    private ObjectWritable objectWritable;
    private Short internalAdapterId = null;
    private ByteArray dataId;

    public void setObject(ObjectWritable data) {
        this.objectWritable = data;
    }

    public ObjectWritable getObjectWritable() {
        return this.objectWritable;
    }

    protected void setObjectWritable(ObjectWritable objectWritable) {
        this.objectWritable = objectWritable;
    }

    public Short getInternalAdapterId() {
        return this.internalAdapterId;
    }

    public void setInternalAdapterId(short internalAdapterId) {
        this.internalAdapterId = internalAdapterId;
    }

    public ByteArray getDataId() {
        return this.dataId;
    }

    public void setDataId(ByteArray dataId) {
        this.dataId = dataId;
    }

    public void readFields(DataInput input) throws IOException {
        this.internalAdapterId = input.readShort();
        int dataIdLength = input.readUnsignedShort();
        if (dataIdLength > 0) {
            byte[] dataIdBinary = new byte[dataIdLength];
            input.readFully(dataIdBinary);
            this.dataId = new ByteArray(dataIdBinary);
        }
        if (this.objectWritable == null) {
            this.objectWritable = new ObjectWritable();
        }
        this.objectWritable.readFields(input);
    }

    public void write(DataOutput output) throws IOException {
        output.writeShort(this.internalAdapterId.shortValue());
        if (this.dataId != null) {
            byte[] dataIdBinary = this.dataId.getBytes();
            output.writeShort((short)dataIdBinary.length);
            output.write(dataIdBinary);
        } else {
            output.writeShort(0);
        }
        this.objectWritable.write(output);
    }

    public static void fillWritableWithAdapter(HadoopWritableSerializationTool serializationTool, AdapterWithObjectWritable writableToFill, short internalAdapterId, ByteArray dataId, Object entry) {
        writableToFill.setInternalAdapterId(internalAdapterId);
        writableToFill.setDataId(dataId);
        writableToFill.setObject(serializationTool.toWritable(internalAdapterId, entry));
    }

    public static Object fromWritableWithAdapter(HadoopWritableSerializationTool serializationTool, AdapterWithObjectWritable writableToExtract) {
        short internalAdapterId = writableToExtract.getInternalAdapterId();
        Object innerObj = writableToExtract.objectWritable.get();
        return innerObj instanceof Writable ? serializationTool.getHadoopWritableSerializerForAdapter(internalAdapterId).fromWritable((Writable)innerObj) : innerObj;
    }

    public String toString() {
        return "AdapterWithObjectWritable [ internalAdapterId=" + this.internalAdapterId + ", dataId=" + this.dataId.getString() + "]";
    }
}

