/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.justification.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import org.liveontologies.protege.explanation.justification.service.JustificationComputation;
import org.liveontologies.protege.explanation.justification.service.JustificationListener;
import org.semanticweb.owlapi.model.OWLAxiom;

public abstract class JustificationComputationManager {
    private final OWLAxiom entailment_;
    private final JustificationListener listener_;
    private final JustificationComputation.InterruptMonitor monitor_;
    private final List<ChangeListener> changeListeners_ = new ArrayList<ChangeListener>();

    public JustificationComputationManager(OWLAxiom entailment, JustificationListener listener, JustificationComputation.InterruptMonitor monitor) {
        this.entailment_ = entailment;
        this.listener_ = listener;
        this.monitor_ = monitor;
    }

    public OWLAxiom getEntailment() {
        return this.entailment_;
    }

    public JustificationListener getJustificationListener() {
        return this.listener_;
    }

    public JustificationComputation.InterruptMonitor getInterruptMonitor() {
        return this.monitor_;
    }

    public void addListener(ChangeListener listener) {
        this.changeListeners_.add(listener);
    }

    public void removeListener(ChangeListener listener) {
        this.changeListeners_.remove(listener);
    }

    public JPanel getSettingsPanel() {
        return null;
    }

    public Collection<? extends Set<OWLAxiom>> getInitialJustifications() {
        return Collections.emptyList();
    }

    public abstract JustificationComputation getComputation();

    protected void notifyJustificationsOutdated() {
        for (ChangeListener listener : this.changeListeners_) {
            listener.justificationsOutdated();
        }
    }

    public static interface ChangeListener {
        public void justificationsOutdated();

        public void settingsPanelChanged();
    }
}

