/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.justification.priority;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.liveontologies.protege.explanation.justification.priority.JustificationPriority;
import org.liveontologies.protege.explanation.justification.priority.OwlAxiomType;
import org.liveontologies.protege.explanation.justification.priority.OwlAxiomTypes;
import org.semanticweb.owlapi.model.ClassExpressionType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;

public class JustificationPriorityFactory {
    private Map<OWLAxiom, CacheRecord> cache_ = new HashMap<OWLAxiom, CacheRecord>();
    private final Set<OwlAxiomType> axiomTypes_ = EnumSet.noneOf(OwlAxiomType.class);
    private final Set<ClassExpressionType> classExpressionTypes_ = EnumSet.noneOf(ClassExpressionType.class);

    public JustificationPriority getPriority(Set<? extends OWLAxiom> justification) {
        int size = 0;
        this.axiomTypes_.clear();
        this.classExpressionTypes_.clear();
        for (OWLAxiom oWLAxiom : justification) {
            ++size;
            CacheRecord record = this.cache_.get(oWLAxiom);
            if (record == null) {
                record = new CacheRecord(oWLAxiom);
                this.cache_.put(oWLAxiom, record);
            }
            this.axiomTypes_.add(record.axiomType_);
            this.classExpressionTypes_.addAll(record.classExpressionTypes_);
        }
        return new JustificationPriority(this.axiomTypes_.size(), this.classExpressionTypes_.size(), size);
    }

    static class CacheRecord {
        private final OwlAxiomType axiomType_;
        private final Set<ClassExpressionType> classExpressionTypes_ = EnumSet.noneOf(ClassExpressionType.class);

        CacheRecord(OWLAxiom axiom) {
            this.axiomType_ = OwlAxiomTypes.getAxiomType(axiom);
            this.classExpressionTypes_.addAll(axiom.getNestedClassExpressions().stream().map(OWLClassExpression::getClassExpressionType).collect(Collectors.toList()));
        }
    }
}

