/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.justification.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.liveontologies.protege.explanation.justification.JustificationComputationServiceManager;
import org.liveontologies.protege.explanation.justification.preferences.JustPrefs;
import org.liveontologies.protege.explanation.justification.service.JustificationComputationService;
import org.protege.editor.core.ui.preferences.PreferencesLayoutPanel;
import org.protege.editor.owl.ui.preferences.OWLPreferencesPanel;

public class JustificationPreferencesGeneralPanel
extends OWLPreferencesPanel {
    private static final long serialVersionUID = 2271633237554797195L;
    private static ArrayList<PreferencesListener> listeners_ = new ArrayList();
    private SpinnerNumberModel initialAmountM_;
    private SpinnerNumberModel incrementM_;
    private JCheckBox showPopularityChB_;

    public void initialise() throws Exception {
        this.setLayout(new BorderLayout());
        PreferencesLayoutPanel panel = new PreferencesLayoutPanel();
        this.add((Component)panel, "North");
        panel.addGroup("Installed justification services");
        DefaultListModel<String> pluginModel = new DefaultListModel<String>();
        JustificationComputationServiceManager manager = JustificationComputationServiceManager.get(this.getOWLEditorKit());
        for (JustificationComputationService service : manager.getServices()) {
            pluginModel.addElement(service.getName());
        }
        JList pluginList = new JList(pluginModel);
        pluginList.setToolTipText("Plugins that provide justification facilities");
        JScrollPane pluginInfoScrollPane = new JScrollPane(pluginList);
        pluginInfoScrollPane.setPreferredSize(new Dimension(300, 100));
        panel.addGroupComponent((JComponent)pluginInfoScrollPane);
        panel.addGroup("Initial justifications");
        this.initialAmountM_ = new SpinnerNumberModel(1, 1, 999, 1);
        JSpinner spinnerIA = new JSpinner(this.initialAmountM_);
        spinnerIA.setMaximumSize(spinnerIA.getPreferredSize());
        panel.addGroupComponent((JComponent)spinnerIA);
        spinnerIA.setToolTipText("The maximal number of justifications displayed at the beginning");
        panel.addGroup("Increment value");
        this.incrementM_ = new SpinnerNumberModel(1, 1, 999, 1);
        JSpinner spinnerI = new JSpinner(this.incrementM_);
        spinnerI.setMaximumSize(spinnerI.getPreferredSize());
        panel.addGroupComponent((JComponent)spinnerI);
        spinnerI.setToolTipText("The maximal number of further justifications that can be loaded at once");
        panel.addGroup("");
        JButton resetButton = new JButton("Reset");
        resetButton.addActionListener(e -> this.reset());
        resetButton.setToolTipText("Resets all settings to default values");
        panel.addGroupComponent((JComponent)resetButton);
        this.loadFrom(JustPrefs.create().load());
    }

    public void dispose() throws Exception {
    }

    public void applyChanges() {
        JustPrefs prefs = JustPrefs.create();
        this.saveTo(prefs);
        prefs.save();
        for (PreferencesListener listener : listeners_) {
            listener.valueChanged();
        }
    }

    private void loadFrom(JustPrefs prefs) {
        this.incrementM_.setValue(prefs.increment);
        this.initialAmountM_.setValue(prefs.initialNumber);
    }

    private void saveTo(JustPrefs prefs) {
        prefs.increment = this.incrementM_.getNumber().intValue();
        prefs.initialNumber = this.initialAmountM_.getNumber().intValue();
    }

    private void reset() {
        this.loadFrom(JustPrefs.create());
    }

    public static void addListener(PreferencesListener listener) {
        listeners_.add(listener);
    }

    public static void removeListener(PreferencesListener listener) {
        listeners_.remove(listener);
    }

    public static interface PreferencesListener {
        public void valueChanged();
    }
}

