/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.justification.preferences;

import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;

public class JustPrefs {
    private static final String PREFS_KEY_ = "JUSTIFICATION_EXPLANATION_PREFS";
    private static final String INCREMENT_KEY_ = "INCREMENT";
    private static final String INITIAL_NUMBER_KEY_ = "INITIAL_NUMBER";
    public static final String INCREMENT_DESCRIPTION = "The maximal number of further justifications that can be loaded at once";
    public static final String INITIAL_NUMBER_DESCRIPTION = "The maximal number of justifications displayed at the beginning";
    private static final int DEFAULT_INCREMENT_ = 10;
    private static final int DEFAULT_INITIAL_NUMBER_ = 20;
    public int increment = 10;
    public int initialNumber = 20;

    private JustPrefs() {
    }

    private static Preferences getPrefs() {
        PreferencesManager prefMan = PreferencesManager.getInstance();
        return prefMan.getPreferencesForSet(PREFS_KEY_, JustPrefs.class);
    }

    public static JustPrefs create() {
        return new JustPrefs();
    }

    public JustPrefs load() {
        Preferences prefs = JustPrefs.getPrefs();
        this.increment = prefs.getInt(INCREMENT_KEY_, 10);
        this.initialNumber = prefs.getInt(INITIAL_NUMBER_KEY_, 20);
        return this;
    }

    public JustPrefs save() {
        Preferences prefs = JustPrefs.getPrefs();
        prefs.putInt(INCREMENT_KEY_, this.increment);
        prefs.putInt(INITIAL_NUMBER_KEY_, this.initialNumber);
        return this;
    }

    public JustPrefs reset() {
        this.increment = 10;
        this.initialNumber = 20;
        return this;
    }
}

