/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.justification.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import org.liveontologies.protege.explanation.justification.preferences.JustificationPreferencesPanelPluginLoader;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.core.ui.preferences.PreferencesPanel;
import org.protege.editor.core.ui.preferences.PreferencesPanelPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JustPrefPanel
extends PreferencesPanel
implements Disposable {
    private static final long serialVersionUID = -2626712731291697883L;
    private static final String JUST_PREFS_HISTORY_PANEL_KEY = "just.prefs.history.panel";
    private final Map<String, PreferencesPanel> panels_ = new HashMap<String, PreferencesPanel>();
    private final Map<String, JComponent> panes_ = new HashMap<String, JComponent>();
    private final JTabbedPane tabbedPane_ = new JTabbedPane();
    private final Logger logger_ = LoggerFactory.getLogger(JustPrefPanel.class);

    public void initialise() throws Exception {
        this.setLayout(new BorderLayout());
        JustificationPreferencesPanelPluginLoader loader = new JustificationPreferencesPanelPluginLoader(this.getEditorKit());
        TreeSet plugins = new TreeSet((o1, o2) -> {
            String s1 = o1.getLabel();
            String s2 = o2.getLabel();
            return s1.compareTo(s2);
        });
        plugins.addAll(loader.getPlugins());
        for (PreferencesPanelPlugin plugin : plugins) {
            try {
                PreferencesPanel panel = (PreferencesPanel)plugin.newInstance();
                panel.initialise();
                String label = plugin.getLabel();
                JScrollPane sp = new JScrollPane((Component)panel);
                sp.setBorder(new EmptyBorder(0, 0, 0, 0));
                this.panels_.put(label, panel);
                this.panes_.put(label, sp);
                this.tabbedPane_.addTab(label, sp);
            }
            catch (Throwable e) {
                this.logger_.warn("An error occurred whilst trying to instantiate the justification preferences panel plugin '{}': {}", (Object)plugin.getLabel(), (Object)e);
            }
        }
        this.add(this.tabbedPane_);
        this.updatePanelSelection(null);
    }

    public void dispose() throws Exception {
        Preferences prefs = PreferencesManager.getInstance().getApplicationPreferences(JustPrefPanel.class);
        prefs.putString(JUST_PREFS_HISTORY_PANEL_KEY, this.getSelectedPanel());
        for (PreferencesPanel panel : new ArrayList<PreferencesPanel>(this.panels_.values())) {
            try {
                panel.dispose();
            }
            catch (Throwable e) {
                this.logger_.warn("An error occurred whilst disposing of the justification preferences panel plugin '{}': {}", (Object)panel.getLabel(), (Object)e);
            }
        }
        this.panels_.clear();
    }

    protected String getSelectedPanel() {
        Component c = this.tabbedPane_.getSelectedComponent();
        if (c instanceof JScrollPane) {
            c = ((JScrollPane)c).getViewport().getView();
        }
        for (String tabName : this.panels_.keySet()) {
            if (!c.equals(this.panels_.get(tabName))) continue;
            return tabName;
        }
        return null;
    }

    public void updatePanelSelection(String selectedPanel) {
        Component c;
        if (selectedPanel == null) {
            Preferences prefs = PreferencesManager.getInstance().getApplicationPreferences(JustPrefPanel.class);
            selectedPanel = prefs.getString(JUST_PREFS_HISTORY_PANEL_KEY, null);
        }
        if ((c = (Component)this.panes_.get(selectedPanel)) != null) {
            this.tabbedPane_.setSelectedComponent(c);
        }
    }

    public void applyChanges() {
        for (PreferencesPanel panel : new ArrayList<PreferencesPanel>(this.panels_.values())) {
            try {
                panel.applyChanges();
            }
            catch (Throwable e) {
                this.logger_.warn("An error occurred whilst trying to save the preferences for the justification preferences panel '{}': {}", (Object)panel.getLabel(), (Object)e);
            }
        }
    }
}

