/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.justification;

import org.liveontologies.protege.explanation.justification.JustificationComputationServiceManager;
import org.liveontologies.protege.explanation.justification.PresentationPanel;
import org.liveontologies.protege.explanation.justification.PresentationPanelResult;
import org.liveontologies.protege.explanation.justification.service.JustificationComputationService;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.explanation.ExplanationResult;
import org.protege.editor.owl.ui.explanation.ExplanationService;
import org.semanticweb.owlapi.model.OWLAxiom;

public class PresentationService
extends ExplanationService {
    private JustificationComputationServiceManager manager_;

    public void initialise() throws Exception {
        OWLEditorKit kit = this.getOWLEditorKit();
        this.manager_ = JustificationComputationServiceManager.get(kit);
    }

    public boolean hasExplanation(OWLAxiom axiom) {
        for (JustificationComputationService service : this.manager_.getServices()) {
            if (!service.canJustify(axiom)) continue;
            return true;
        }
        return false;
    }

    public ExplanationResult explain(OWLAxiom axiom) {
        PresentationPanel panel = new PresentationPanel(this.manager_, axiom);
        return new PresentationPanelResult(panel);
    }

    public void dispose() throws Exception {
    }
}

