/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.justification;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.liveontologies.protege.explanation.justification.AxiomSelectionListener;
import org.liveontologies.protege.explanation.justification.AxiomSelectionModel;
import org.liveontologies.protege.explanation.justification.AxiomSelectionModelImpl;
import org.liveontologies.protege.explanation.justification.Explanation;
import org.liveontologies.protege.explanation.justification.ExplanationGeneratorProgressDialog;
import org.liveontologies.protege.explanation.justification.JustificationComputationListener;
import org.liveontologies.protege.explanation.justification.JustificationComputationServiceManager;
import org.liveontologies.protege.explanation.justification.JustificationFrameList;
import org.liveontologies.protege.explanation.justification.JustificationManager;
import org.liveontologies.protege.explanation.justification.PartialListVisualizer;
import org.liveontologies.protege.explanation.justification.preferences.JustPrefPanel;
import org.liveontologies.protege.explanation.justification.preferences.JustPrefs;
import org.liveontologies.protege.explanation.justification.priority.PrioritizedJustification;
import org.liveontologies.protege.explanation.justification.service.JustificationComputation;
import org.liveontologies.protege.explanation.justification.service.JustificationComputationService;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.plugin.PluginUtilities;
import org.semanticweb.owlapi.model.OWLAxiom;

public class PresentationPanel
extends JPanel
implements Disposable,
AxiomSelectionModel,
JustificationManager.ChangeListener,
PartialListVisualizer {
    private static final long serialVersionUID = 5025702425365703918L;
    private final JustificationManager manager_;
    private final ExplanationGeneratorProgressDialog progressDialog_;
    private final JScrollPane scrollPane_;
    private final JComponent serviceSettingsDisplayHolder_;
    private final JustificationFrameList frameList_;
    private final AxiomSelectionModelImpl selectionModel_ = new AxiomSelectionModelImpl();
    private int displayedJustificationCount_ = 0;

    public PresentationPanel(final JustificationComputationServiceManager serviceManager, OWLAxiom entailment) {
        boolean bExplPrefExtPointExists;
        this.progressDialog_ = new ExplanationGeneratorProgressDialog(serviceManager.getOwlEditorKit());
        this.manager_ = new JustificationManager(serviceManager, entailment, (JustificationComputationListener)this.progressDialog_, (JustificationComputation.InterruptMonitor)this.progressDialog_);
        this.manager_.addListener(this);
        this.setLayout(new BorderLayout());
        Box headerPanel = new Box(1);
        JPanel panel1 = new JPanel(new BorderLayout());
        boolean bl = bExplPrefExtPointExists = PluginUtilities.getInstance().getExtensionRegistry().getExtensionPoint("org.protege.editor.core.application", "explanationpreferencespanel") == null;
        if (bExplPrefExtPointExists) {
            JButton b = new JButton("\ufffd");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        JustPrefPanel prefPanel = new JustPrefPanel();
                        prefPanel.setup(prefPanel.getLabel(), (EditorKit)serviceManager.getOwlEditorKit());
                        prefPanel.initialise();
                        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                        int margin = 100;
                        int prefWidth = Math.min(screenSize.width - margin, 850);
                        int prefHeight = Math.min(screenSize.height - margin, 600);
                        prefPanel.setPreferredSize(new Dimension(prefWidth, prefHeight));
                        JOptionPane op = new JOptionPane((Object)prefPanel, -1, -1);
                        JDialog dlg = op.createDialog((Component)serviceManager.getOwlEditorKit().getWorkspace(), "Justification preferences");
                        dlg.setResizable(true);
                        dlg.setVisible(true);
                        Object o = op.getValue();
                        if (o != null && (Integer)o == 0) {
                            prefPanel.applyChanges();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            panel1.add((Component)b, "East");
        }
        headerPanel.add(panel1);
        this.serviceSettingsDisplayHolder_ = new JPanel(new BorderLayout());
        headerPanel.add(this.serviceSettingsDisplayHolder_);
        this.add((Component)headerPanel, "North");
        Explanation explanation_ = new Explanation(this.manager_.getEntailment());
        this.frameList_ = new JustificationFrameList(this, this.manager_, this, explanation_);
        this.scrollPane_ = new JScrollPane((Component)((Object)this.frameList_));
        this.scrollPane_.setMinimumSize(new Dimension(10, 10));
        this.scrollPane_.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.scrollPane_.setHorizontalScrollBarPolicy(31);
        this.add((Component)this.scrollPane_, "Center");
        Collection<JustificationComputationService> services = this.manager_.getServices();
        JustificationComputationService selectedService = null;
        switch (services.size()) {
            case 0: {
                break;
            }
            case 1: {
                selectedService = services.iterator().next();
                this.manager_.selectJusificationService(selectedService);
                JLabel label = new JLabel("Using " + selectedService + " as a computation service");
                panel1.add((Component)label, "East");
                break;
            }
            default: {
                JustificationComputationService defaultService = serviceManager.getDefaultService();
                final JComboBox<JustificationComputationService> selector = new JComboBox<JustificationComputationService>();
                for (JustificationComputationService service : services) {
                    if (selectedService == null || service == defaultService) {
                        selectedService = service;
                    }
                    selector.addItem(service);
                }
                selector.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PresentationPanel.this.manager_.selectJusificationService((JustificationComputationService)selector.getSelectedItem());
                    }
                });
                selector.setSelectedItem(selectedService);
                panel1.add(selector, "Center");
            }
        }
    }

    @Override
    public String getShowMoreJustificationsDescription() {
        int remainingJustificationsCount = this.manager_.getRemainingJustificationCount();
        int nextCount = Math.min(JustPrefs.create().load().increment, remainingJustificationsCount);
        return "Show " + (nextCount == remainingJustificationsCount ? "last " : "next ") + nextCount + " justification" + (nextCount == 1 ? "" : "s");
    }

    @Override
    public int getDisplayedJustificationCount() {
        return this.displayedJustificationCount_;
    }

    public String getComputedJustificationsDescription() {
        int computedJustifications = this.displayedJustificationCount_ + this.manager_.getRemainingJustificationCount();
        return computedJustifications + " justification" + (computedJustifications == 1 ? "" : "s") + " computed";
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(10, 10);
    }

    private void refreshSettingsPanel() {
        this.serviceSettingsDisplayHolder_.removeAll();
        JPanel settingsPanel = this.manager_.getSettingsPanel();
        this.serviceSettingsDisplayHolder_.repaint();
        if (settingsPanel != null) {
            this.serviceSettingsDisplayHolder_.add(settingsPanel);
        }
        this.validate();
    }

    private void refreshAddJustifications() {
        this.frameList_.setAddJustificationsSectionVisibility(this.manager_.getRemainingJustificationCount() != 0);
    }

    private void refreshCounters() {
        this.frameList_.setStatusString(this.getComputedJustificationsDescription());
        this.refreshAddJustifications();
    }

    private void reloadJustifications() {
        this.displayedJustificationCount_ = 0;
        this.frameList_.clear();
        this.loadMoreJustifications(JustPrefs.create().load().initialNumber);
        this.refreshCounters();
    }

    private void loadMoreJustifications(int maxToLoad) {
        while (maxToLoad > 0) {
            --maxToLoad;
            PrioritizedJustification next = this.manager_.pollJustification();
            if (next == null) break;
            ++this.displayedJustificationCount_;
            this.frameList_.addJustification(next, this.displayedJustificationCount_);
        }
        this.refreshAddJustifications();
    }

    public void dispose() {
        this.frameList_.dispose();
        this.selectionModel_.dispose();
    }

    @Override
    public void addAxiomSelectionListener(AxiomSelectionListener lsnr) {
        this.selectionModel_.addAxiomSelectionListener(lsnr);
    }

    @Override
    public void removeAxiomSelectionListener(AxiomSelectionListener lsnr) {
        this.selectionModel_.removeAxiomSelectionListener(lsnr);
    }

    @Override
    public void setAxiomSelected(OWLAxiom axiom, boolean b) {
        this.selectionModel_.setAxiomSelected(axiom, b);
    }

    @Override
    public Set<OWLAxiom> getSelectedAxioms() {
        return this.selectionModel_.getSelectedAxioms();
    }

    @Override
    public void clearSelection() {
        this.selectionModel_.clearSelection();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension workspaceSize = this.manager_.getOwlEditorKit().getWorkspace().getSize();
        int width = (int)(workspaceSize.getWidth() * 0.8);
        int height = (int)(workspaceSize.getHeight() * 0.7);
        return new Dimension(width, height);
    }

    @Override
    public void showNext(int number) {
        this.loadMoreJustifications(number);
    }

    @Override
    public void showNext() {
        this.showNext(JustPrefs.create().load().increment);
    }

    @Override
    public void reset() {
        this.manager_.recomputeJustifications();
    }

    @Override
    public void justificationsRecomputed() {
        SwingUtilities.invokeLater(() -> this.reloadJustifications());
    }

    @Override
    public void settingsPanelChanged() {
        SwingUtilities.invokeLater(() -> this.refreshSettingsPanel());
    }
}

