/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.justification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JPanel;
import org.liveontologies.protege.explanation.justification.JustificationComputationListener;
import org.liveontologies.protege.explanation.justification.JustificationComputationServiceManager;
import org.liveontologies.protege.explanation.justification.priority.JustificationPriority;
import org.liveontologies.protege.explanation.justification.priority.PrioritizedJustification;
import org.liveontologies.protege.explanation.justification.priority.PrioritizedJustificationFactory;
import org.liveontologies.protege.explanation.justification.service.JustificationComputation;
import org.liveontologies.protege.explanation.justification.service.JustificationComputationManager;
import org.liveontologies.protege.explanation.justification.service.JustificationComputationService;
import org.liveontologies.protege.explanation.justification.service.JustificationListener;
import org.liveontologies.protege.explanation.justification.service.JustificationPriorityComparator;
import org.protege.editor.core.log.LogBanner;
import org.protege.editor.owl.OWLEditorKit;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JustificationManager
implements JustificationComputationManager.ChangeListener,
JustificationListener {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(JustificationManager.class);
    private final JustificationComputationServiceManager serviceMan_;
    private final OWLAxiom entailment_;
    private final JustificationComputationListener computationListener_;
    private final JustificationComputation.InterruptMonitor interruptMonitor_;
    private final ExecutorService executorService_;
    private final Queue<PrioritizedJustification> justifications_ = new PriorityQueue<PrioritizedJustification>();
    private final PrioritizedJustificationFactory justificationFactory_ = new PrioritizedJustificationFactory();
    private int justificationCount_ = 0;
    private final Map<OWLAxiom, Integer> axiomsPopularity_ = new HashMap<OWLAxiom, Integer>();
    private JustificationComputationService selectedComputationService_;
    private JustificationComputationManager computationManager_;
    private JPanel computationSettingsPanel_;
    private final List<ChangeListener> listeners_ = new ArrayList<ChangeListener>();

    JustificationManager(JustificationComputationServiceManager serviceManager, OWLAxiom entailment, JustificationComputationListener computationListener, JustificationComputation.InterruptMonitor interruptMonitor) {
        this.serviceMan_ = serviceManager;
        this.entailment_ = entailment;
        this.computationListener_ = computationListener;
        this.interruptMonitor_ = interruptMonitor;
        this.executorService_ = Executors.newSingleThreadExecutor();
    }

    JustificationManager(OWLEditorKit kit, OWLAxiom entailment, JustificationComputationListener computationListener, JustificationComputation.InterruptMonitor interruptMonitor) throws Exception {
        this(JustificationComputationServiceManager.get(kit), entailment, computationListener, interruptMonitor);
    }

    public OWLAxiom getEntailment() {
        return this.entailment_;
    }

    public OWLEditorKit getOwlEditorKit() {
        return this.serviceMan_.getOwlEditorKit();
    }

    public Collection<JustificationComputationService> getServices() {
        ArrayList<JustificationComputationService> result = new ArrayList<JustificationComputationService>();
        for (JustificationComputationService service : this.serviceMan_.getServices()) {
            if (!service.canJustify(this.entailment_)) continue;
            result.add(service);
        }
        return result;
    }

    private void resetJustifications() {
        this.justifications_.clear();
        this.justificationCount_ = 0;
        this.axiomsPopularity_.clear();
    }

    private void addJustification(Set<OWLAxiom> justification) {
        this.justifications_.add(this.justificationFactory_.createJustification(justification));
        ++this.justificationCount_;
        for (OWLAxiom axiom : justification) {
            Integer popularity = this.axiomsPopularity_.get(axiom);
            if (popularity == null) {
                popularity = 0;
            }
            Integer n = popularity;
            popularity = popularity + 1;
            this.axiomsPopularity_.put(axiom, popularity);
        }
    }

    public JPanel getSettingsPanel() {
        return this.computationSettingsPanel_;
    }

    public synchronized void selectJusificationService(JustificationComputationService service) {
        if (this.selectedComputationService_ == service) {
            return;
        }
        this.selectedComputationService_ = service;
        this.serviceMan_.setDefaultService(service);
        if (this.computationManager_ != null) {
            this.computationManager_.removeListener(this);
        }
        this.computationManager_ = service.createComputationManager(this.entailment_, this, this.interruptMonitor_);
        this.computationSettingsPanel_ = this.computationManager_.getSettingsPanel();
        this.notifySettingsPanelChanged();
        this.initializeJustifications();
        this.computationManager_.addListener(this);
    }

    @Override
    public void justificationsOutdated() {
        this.initializeJustifications();
    }

    @Override
    public void settingsPanelChanged() {
        this.notifySettingsPanelChanged();
    }

    @Override
    public void justificationFound(Set<OWLAxiom> justification) {
        this.addJustification(justification);
        this.computationListener_.justificationFound(justification);
    }

    void initializeJustifications() {
        Collection<? extends Set<OWLAxiom>> initial = this.computationManager_.getInitialJustifications();
        if (initial.isEmpty()) {
            this.recomputeJustifications();
        } else {
            this.resetJustifications();
            for (Set<OWLAxiom> set : initial) {
                this.justificationFound(set);
            }
            this.notifyJustificationsRecomputed();
        }
    }

    void recomputeJustifications() {
        this.resetJustifications();
        try {
            this.computationListener_.computationStarted();
            this.executorService_.submit(new ExplanationComputationTask());
        }
        catch (OWLRuntimeException e) {
            LOGGER_.info("Justification computation terminated early by user");
        }
    }

    public synchronized void addListener(ChangeListener listener) {
        this.listeners_.add(listener);
    }

    public synchronized void removeListener(ChangeListener listener) {
        this.listeners_.remove(listener);
    }

    public PrioritizedJustification pollJustification() {
        if (this.justificationCount_ == 0) {
            return null;
        }
        --this.justificationCount_;
        return this.justifications_.poll();
    }

    public int getRemainingJustificationCount() {
        return this.justificationCount_;
    }

    public int getPopularity(OWLAxiom axiom) {
        return this.axiomsPopularity_.get(axiom);
    }

    private void notifyJustificationsRecomputed() {
        int i;
        try {
            for (i = 0; i < this.listeners_.size(); ++i) {
                this.listeners_.get(i).justificationsRecomputed();
            }
        }
        catch (Throwable e) {
            LOGGER_.warn("Remove the listener due to an exception", e);
            this.removeListener(this.listeners_.get(i));
        }
    }

    private void notifySettingsPanelChanged() {
        int i;
        try {
            for (i = 0; i < this.listeners_.size(); ++i) {
                this.listeners_.get(i).settingsPanelChanged();
            }
        }
        catch (Throwable e) {
            LOGGER_.warn("Remove the listener due to an exception", e);
            this.removeListener(this.listeners_.get(i));
        }
    }

    private class ExplanationComputationTask
    implements Runnable,
    JustificationPriorityComparator<JustificationPriority> {
        private final JustificationComputation computation_;

        private ExplanationComputationTask() {
            this.computation_ = JustificationManager.this.computationManager_.getComputation();
            this.computation_.setPrefferredPriority(this);
        }

        @Override
        public void run() {
            try {
                LOGGER_.info(LogBanner.start((String)"Computing Justifications"));
                LOGGER_.info("Computing justifications for {}", (Object)JustificationManager.this.entailment_);
                JustificationManager.this.computationListener_.computationStarted();
                this.computation_.startComputation();
            }
            catch (Throwable e) {
                LOGGER_.info("Exception while computing justifications", e);
            }
            finally {
                JustificationManager.this.computationListener_.computationFinished();
                LOGGER_.info("A total of {} justifications have been computed", (Object)JustificationManager.this.justificationCount_);
                LOGGER_.info(LogBanner.end());
                JustificationManager.this.notifyJustificationsRecomputed();
            }
        }

        @Override
        public int compare(JustificationPriority p1, JustificationPriority p2) {
            return p1.compareTo(p2);
        }

        @Override
        public JustificationPriority getPriority(Set<OWLAxiom> justification) {
            return JustificationManager.this.justificationFactory_.getPriorityFactory().getPriority(justification);
        }
    }

    public static interface ChangeListener {
        public void justificationsRecomputed();

        public void settingsPanelChanged();
    }
}

