/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.justification;

import java.util.Comparator;
import java.util.List;
import org.liveontologies.protege.explanation.justification.Explanation;
import org.liveontologies.protege.explanation.justification.JustificationFormattingManager;
import org.liveontologies.protege.explanation.justification.JustificationFrameSectionRow;
import org.liveontologies.protege.explanation.justification.priority.PrioritizedJustification;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;

public class JustificationFrameSection
extends AbstractOWLFrameSection<Explanation, OWLAxiom, OWLAxiom> {
    private boolean isFilled_ = false;
    private final Explanation explanation_;
    private final int justificationIndex_;

    public JustificationFrameSection(OWLEditorKit editorKit, OWLFrame<? extends Explanation> owlFrame, String caption, int justificationIndex) {
        super(editorKit, caption, owlFrame);
        this.explanation_ = (Explanation)owlFrame.getRootObject();
        this.justificationIndex_ = justificationIndex;
    }

    protected OWLAxiom createAxiom(OWLAxiom object) {
        return object;
    }

    public OWLObjectEditor<OWLAxiom> getObjectEditor() {
        return null;
    }

    protected void refill(OWLOntology ontology) {
        if (this.isFilled_) {
            return;
        }
        this.isFilled_ = true;
        PrioritizedJustification justification = this.getJustification();
        if (justification.getSize() == 0) {
            this.setLabel("The axiom is a tautology");
        } else {
            JustificationFormattingManager formattingManager = JustificationFormattingManager.getInstance();
            OWLAxiom entailment = this.explanation_.getEntailment();
            List<OWLAxiom> formatting = formattingManager.getOrdering(entailment, justification);
            for (OWLAxiom axiom : formatting) {
                int depth = formattingManager.getIndentation(entailment, justification, axiom);
                JustificationFrameSectionRow row = new JustificationFrameSectionRow(this.getOWLEditorKit(), (OWLFrameSection<Explanation, OWLAxiom, OWLAxiom>)this, this.explanation_, axiom, depth);
                this.addRow((OWLFrameSectionRow)row);
            }
        }
    }

    protected void clear() {
        this.isFilled_ = false;
    }

    public PrioritizedJustification getJustification() {
        return this.explanation_.getJustification(this.justificationIndex_);
    }

    public Comparator<OWLFrameSectionRow<Explanation, OWLAxiom, OWLAxiom>> getRowComparator() {
        return null;
    }

    public boolean canAdd() {
        return false;
    }

    public boolean canAcceptDrop(List<OWLObject> objects) {
        return false;
    }
}

