/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.justification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.liveontologies.protege.explanation.justification.ProtegeExplanationOrderer;
import org.liveontologies.protege.explanation.justification.priority.PrioritizedJustification;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLAxiom;
import uk.ac.manchester.cs.owl.explanation.ordering.ExplanationTree;
import uk.ac.manchester.cs.owl.explanation.ordering.Tree;

public class JustificationFormattingManager {
    private static final JustificationFormattingManager instance_ = new JustificationFormattingManager();
    private final Map<PrioritizedJustification, Map<OWLAxiom, Integer>> indents_ = new HashMap<PrioritizedJustification, Map<OWLAxiom, Integer>>();
    private final Map<PrioritizedJustification, List<OWLAxiom>> ordering_ = new HashMap<PrioritizedJustification, List<OWLAxiom>>();

    private JustificationFormattingManager() {
    }

    public static JustificationFormattingManager getInstance() {
        return instance_;
    }

    private void init(OWLAxiom entailment, PrioritizedJustification justification) {
        ProtegeExplanationOrderer orderer = new ProtegeExplanationOrderer(OWLManager.createOWLOntologyManager());
        ExplanationTree tree = orderer.getOrderedExplanation(entailment, justification.getAxioms());
        ArrayList<OWLAxiom> ordering = new ArrayList<OWLAxiom>();
        HashMap<OWLAxiom, Integer> im = new HashMap<OWLAxiom, Integer>();
        JustificationFormattingManager.fill((Tree<OWLAxiom>)tree, ordering, im);
        this.indents_.put(justification, im);
        this.ordering_.put(justification, ordering);
    }

    private static void fill(Tree<OWLAxiom> tree, List<OWLAxiom> ordering, Map<OWLAxiom, Integer> indents) {
        if (!tree.isRoot()) {
            ordering.add((OWLAxiom)tree.getUserObject());
            indents.put((OWLAxiom)tree.getUserObject(), tree.getPathToRoot().size() - 2);
        } else if (tree.getChildCount() == 0) {
            ordering.add((OWLAxiom)tree.getUserObject());
            indents.put((OWLAxiom)tree.getUserObject(), 0);
        }
        for (Tree child : tree.getChildren()) {
            JustificationFormattingManager.fill((Tree<OWLAxiom>)child, ordering, indents);
        }
    }

    private void initIfNecessary(OWLAxiom entailment, PrioritizedJustification justification) {
        if (!this.indents_.containsKey(justification)) {
            this.init(entailment, justification);
        }
    }

    public int getIndentation(OWLAxiom entailment, PrioritizedJustification justification, OWLAxiom axiom) {
        if (!justification.getAxioms().contains(axiom)) {
            throw new IllegalArgumentException("The explanation does not contain the specified axiom: " + axiom + "  " + justification);
        }
        this.initIfNecessary(entailment, justification);
        Integer i = this.indents_.get(justification).get(axiom);
        if (i != null) {
            return i;
        }
        return 0;
    }

    public void setIndentation(OWLAxiom entailment, PrioritizedJustification justification, OWLAxiom axiom, int indentation) {
        this.initIfNecessary(entailment, justification);
        this.indents_.get(justification).put(axiom, indentation);
    }

    public void increaseIndentation(OWLAxiom entailment, PrioritizedJustification justification, OWLAxiom axiom) {
        this.initIfNecessary(entailment, justification);
        Integer indent = this.getIndentation(entailment, justification, axiom);
        this.setIndentation(entailment, justification, axiom, indent + 1);
    }

    public void decreaseIndentation(OWLAxiom entailment, PrioritizedJustification justification, OWLAxiom axiom) {
        this.initIfNecessary(entailment, justification);
        Integer indent = this.getIndentation(entailment, justification, axiom);
        indent = indent - 1;
        if (indent < 0) {
            indent = 0;
        }
        this.setIndentation(entailment, justification, axiom, indent);
    }

    public boolean moveAxiomUp(OWLAxiom entailment, PrioritizedJustification justification, OWLAxiom axiom) {
        boolean hasMoved;
        this.initIfNecessary(entailment, justification);
        List<OWLAxiom> ordering = this.ordering_.get(justification);
        int index = ordering.indexOf(axiom);
        boolean bl = hasMoved = index > 0;
        if (hasMoved) {
            --index;
        }
        ordering.remove(axiom);
        ordering.add(index, axiom);
        return hasMoved;
    }

    public boolean moveAxiomDown(OWLAxiom entailment, PrioritizedJustification justification, OWLAxiom axiom) {
        boolean hasMoved;
        this.initIfNecessary(entailment, justification);
        List<OWLAxiom> ordering = this.ordering_.get(justification);
        int index = ordering.indexOf(axiom);
        boolean bl = hasMoved = index < ordering.size() - 1;
        if (hasMoved) {
            ++index;
        }
        ordering.remove(axiom);
        ordering.add(index, axiom);
        return hasMoved;
    }

    public List<OWLAxiom> getOrdering(OWLAxiom entailment, PrioritizedJustification justification) {
        this.initIfNecessary(entailment, justification);
        return Collections.unmodifiableList(this.ordering_.get(justification));
    }

    public void clearFormatting(PrioritizedJustification justification) {
        this.indents_.remove(justification);
        this.ordering_.remove(justification);
    }
}

