/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.justification;

import java.util.ArrayList;
import java.util.Collection;
import org.liveontologies.protege.explanation.justification.service.JustificationComputationPlugin;
import org.liveontologies.protege.explanation.justification.service.JustificationComputationPluginLoader;
import org.liveontologies.protege.explanation.justification.service.JustificationComputationService;
import org.protege.editor.core.Disposable;
import org.protege.editor.owl.OWLEditorKit;

public class JustificationComputationServiceManager
implements Disposable {
    private static final String KEY_ = "org.liveontologies.protege.explanation.justification.services";
    private final OWLEditorKit kit_;
    private final Collection<JustificationComputationService> services_;
    private JustificationComputationService defaultService_;

    private JustificationComputationServiceManager(OWLEditorKit kit) throws Exception {
        this.kit_ = kit;
        this.services_ = new ArrayList<JustificationComputationService>();
        JustificationComputationPluginLoader loader = new JustificationComputationPluginLoader(this.kit_);
        for (JustificationComputationPlugin plugin : loader.getPlugins()) {
            JustificationComputationService service = plugin.newInstance();
            service.initialise();
            this.services_.add(service);
        }
    }

    public static synchronized JustificationComputationServiceManager get(OWLEditorKit kit) throws Exception {
        JustificationComputationServiceManager manager = (JustificationComputationServiceManager)kit.getModelManager().get((Object)KEY_);
        if (manager == null) {
            manager = new JustificationComputationServiceManager(kit);
            kit.getModelManager().put((Object)KEY_, (Disposable)manager);
        }
        return manager;
    }

    public void dispose() throws Exception {
        for (JustificationComputationService service : this.services_) {
            service.dispose();
        }
    }

    public OWLEditorKit getOwlEditorKit() {
        return this.kit_;
    }

    public Collection<JustificationComputationService> getServices() {
        return this.services_;
    }

    public JustificationComputationService getDefaultService() {
        return this.defaultService_;
    }

    public void setDefaultService(JustificationComputationService service) {
        this.defaultService_ = service;
    }
}

