/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.justification;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionListener;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import org.protege.editor.core.ui.list.MListButton;

public class MListReloadButton
extends MListButton {
    private static final int ANGLE_START_ = 10;
    private static final int ANGLE_EXTENT_ = 330;
    private final GeneralPath arrowTip_ = new GeneralPath(0, 3);
    private final Arc2D arcBorder_ = new Arc2D.Float();

    protected MListReloadButton(ActionListener actionListener) {
        super("Reload", Color.BLUE.brighter(), actionListener);
    }

    public void paintButtonContent(Graphics2D g) {
        float sizeX = this.getBounds().width;
        float sizeY = this.getBounds().height;
        float height = sizeY / 2.0f;
        float width = sizeX / 2.0f;
        float xCenter = (float)this.getBounds().x + height;
        float yCenter = (float)this.getBounds().y + width;
        int quarterSize = Math.round(width / 4.0f) / 2 * 2;
        float radius = (Math.min(width, height) - (float)quarterSize) / 2.0f;
        double radians = Math.toRadians(10.0);
        double tipX = (double)xCenter + (double)(radius + (float)quarterSize) * Math.cos(radians);
        double tipY = (double)yCenter - (double)radius * Math.sin(radians);
        float tipWidth = 3.0f * radius / 2.0f;
        float tipHeight = 3.0f * radius / 2.0f;
        this.arrowTip_.reset();
        this.arrowTip_.moveTo(tipX, tipY);
        this.arrowTip_.lineTo(tipX - (double)tipWidth, tipY);
        this.arrowTip_.lineTo(tipX, tipY - (double)tipHeight);
        this.arrowTip_.closePath();
        g.fill(this.arrowTip_);
        this.arcBorder_.setArcByCenter(xCenter, yCenter, radius + (float)quarterSize, 10.0, 330.0, 2);
        Area area = new Area(this.arcBorder_);
        this.arcBorder_.setArcByCenter(xCenter, yCenter, radius, 10.0, 330.0, 2);
        area.subtract(new Area(this.arcBorder_));
        g.fill(area);
    }
}

