/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.justification;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import org.liveontologies.protege.explanation.justification.service.JustificationComputation;
import org.liveontologies.protege.explanation.justification.service.JustificationListener;
import org.semanticweb.owlapi.model.OWLAxiom;

public class JustificationProgressPanel
extends JPanel
implements JustificationListener,
JustificationComputation.InterruptMonitor,
ActionListener {
    private static final long serialVersionUID = 5548156306411811469L;
    private static final String MESSAGE = "Computing justifications. Found ";
    private final JLabel messageLabel_;
    private final Action cancelAction_;
    private final Timer timer_;
    private boolean isInterrupted_ = false;
    private int nFound_ = 0;

    public JustificationProgressPanel() {
        this.setLayout(new BorderLayout(12, 12));
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setPreferredSize(new Dimension(400, 100));
        JPanel progressPanel = new JPanel(new BorderLayout(3, 3));
        this.add((Component)progressPanel, "North");
        this.messageLabel_ = new JLabel("Computing justifications. Found 0  ");
        progressPanel.add((Component)this.messageLabel_, "North");
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        progressPanel.add((Component)progressBar, "South");
        this.cancelAction_ = new AbstractAction("Stop searching"){
            private static final long serialVersionUID = 1784308350971019508L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JustificationProgressPanel.this.interrupt();
                this.setEnabled(false);
            }
        };
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.add((Component)buttonPanel, "South");
        buttonPanel.add(new JButton(this.cancelAction_));
        this.timer_ = new Timer(20, this);
        this.timer_.start();
    }

    public void reset() {
        this.nFound_ = 0;
        this.cancelAction_.setEnabled(true);
    }

    public synchronized int getNoFoundJustifications() {
        return this.nFound_;
    }

    @Override
    public synchronized void justificationFound(Set<OWLAxiom> justification) {
        ++this.nFound_;
    }

    @Override
    public synchronized boolean isInterrupted() {
        return this.isInterrupted_;
    }

    private synchronized void interrupt() {
        this.isInterrupted_ = true;
    }

    public synchronized void clearInterrupt() {
        this.isInterrupted_ = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.messageLabel_.setText(MESSAGE + this.nFound_);
        this.timer_.restart();
    }
}

