/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.justification;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.liveontologies.protege.explanation.justification.AddJustificationsSection;
import org.liveontologies.protege.explanation.justification.AxiomSelectionListener;
import org.liveontologies.protege.explanation.justification.AxiomSelectionModel;
import org.liveontologies.protege.explanation.justification.Explanation;
import org.liveontologies.protege.explanation.justification.JustificationFormattingManager;
import org.liveontologies.protege.explanation.justification.JustificationFrame;
import org.liveontologies.protege.explanation.justification.JustificationFrameListRenderer;
import org.liveontologies.protege.explanation.justification.JustificationFrameSection;
import org.liveontologies.protege.explanation.justification.JustificationFrameSectionRow;
import org.liveontologies.protege.explanation.justification.JustificationManager;
import org.liveontologies.protege.explanation.justification.JustificationStatusSection;
import org.liveontologies.protege.explanation.justification.PartialListVisualizer;
import org.liveontologies.protege.explanation.justification.priority.PrioritizedJustification;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.ui.list.MListButton;
import org.protege.editor.core.ui.list.MListItem;
import org.protege.editor.core.ui.list.MListSectionHeader;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.framelist.ExplainButton;
import org.protege.editor.owl.ui.framelist.OWLFrameList;
import org.protege.editor.owl.ui.framelist.OWLFrameListPopupMenuAction;
import org.semanticweb.owlapi.model.OWLAxiom;

public class JustificationFrameList
extends OWLFrameList<Explanation>
implements AxiomSelectionListener,
Disposable {
    private static final long serialVersionUID = -8844035741045455140L;
    private static final Color INFERRED_BG_COLOR_ = new Color(255, 255, 215);
    private static final Color HIGHLIGHT_COLOR_ = new Color(230, 215, 246);
    private static final int AXIOM_INDENT_ = 30;
    private final JustificationManager manager_;
    private final AxiomSelectionModel axiomSelectionModel_;
    private final Explanation explanation_;
    private final JustificationFrame frame_;
    private boolean isTransmittingSelectionToModel_ = false;
    private final PartialListVisualizer justificationPanel_;

    public JustificationFrameList(AxiomSelectionModel axiomSelectionModel, JustificationManager manager, PartialListVisualizer justificationPanel, Explanation explanation) {
        this(axiomSelectionModel, manager, new JustificationFrame(manager.getOwlEditorKit(), explanation, justificationPanel), explanation, justificationPanel);
    }

    private JustificationFrameList(AxiomSelectionModel axiomSelectionModel, JustificationManager manager, JustificationFrame frame, Explanation explanation, PartialListVisualizer justificationPanel) {
        super(manager.getOwlEditorKit(), (OWLFrame)frame);
        this.frame_ = frame;
        this.manager_ = manager;
        this.axiomSelectionModel_ = axiomSelectionModel;
        this.explanation_ = explanation;
        this.justificationPanel_ = justificationPanel;
        OWLEditorKit kit = manager.getOwlEditorKit();
        this.setWrap(false);
        this.setCellRenderer((ListCellRenderer)((Object)new JustificationFrameListRenderer(kit)));
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JustificationFrameList.this.transmitSelectionToModel();
            }
        });
        this.axiomSelectionModel_.addAxiomSelectionListener(new AxiomSelectionListener(){

            @Override
            public void axiomAdded(AxiomSelectionModel source, OWLAxiom axiom) {
                JustificationFrameList.this.respondToAxiomSelectionChange();
            }

            @Override
            public void axiomRemoved(AxiomSelectionModel source, OWLAxiom axiom) {
                JustificationFrameList.this.respondToAxiomSelectionChange();
            }
        });
        AbstractAction moveUpAction = new AbstractAction("Move up"){
            private static final long serialVersionUID = -8758870933492900093L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JustificationFrameList.this.handleMoveUp();
            }
        };
        this.getActionMap().put(moveUpAction.getValue("Name"), moveUpAction);
        this.getInputMap().put(KeyStroke.getKeyStroke(38, 2), moveUpAction.getValue("Name"));
        AbstractAction moveDownAction = new AbstractAction("Move down"){
            private static final long serialVersionUID = -7554058930748542853L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JustificationFrameList.this.handleMoveDown();
            }
        };
        this.getActionMap().put(moveDownAction.getValue("Name"), moveDownAction);
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 2), moveDownAction.getValue("Name"));
        AbstractAction increaseIndentation = new AbstractAction("Increase indentation"){
            private static final long serialVersionUID = 3264353432939432586L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JustificationFrameList.this.handleIncreaseIndentation();
            }
        };
        this.getActionMap().put(increaseIndentation.getValue("Name"), increaseIndentation);
        this.getInputMap().put(KeyStroke.getKeyStroke(39, 2), increaseIndentation.getValue("Name"));
        AbstractAction decreaseIndentation = new AbstractAction("decrease indentation"){
            private static final long serialVersionUID = 4625665722123561472L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JustificationFrameList.this.handleDecreaseIndentation();
            }
        };
        this.getActionMap().put(decreaseIndentation.getValue("Name"), decreaseIndentation);
        this.getInputMap().put(KeyStroke.getKeyStroke(37, 2), decreaseIndentation.getValue("Name"));
    }

    public void addJustification(PrioritizedJustification justification, int justificationNo) {
        int index = this.explanation_.addJustification(justification);
        this.frame_.addSection(index, String.format("Justification %s with %d axioms", justificationNo, justification.getSize()));
        this.validate();
    }

    public void setStatusString(String value) {
        this.frame_.setStatusString(value);
    }

    private void respondToAxiomSelectionChange() {
        if (!this.isTransmittingSelectionToModel_) {
            this.clearSelection();
            this.repaint(this.getVisibleRect());
        }
        this.repaint(this.getVisibleRect());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transmitSelectionToModel() {
        try {
            this.isTransmittingSelectionToModel_ = true;
            this.axiomSelectionModel_.clearSelection();
            for (int i = 0; i < this.getModel().getSize(); ++i) {
                Object element = this.getModel().getElementAt(i);
                if (!(element instanceof JustificationFrameSectionRow) || !this.isSelectedIndex(i)) continue;
                JustificationFrameSectionRow row = (JustificationFrameSectionRow)((Object)element);
                OWLAxiom ax = row.getAxiom();
                this.axiomSelectionModel_.setAxiomSelected(ax, true);
            }
        }
        finally {
            this.isTransmittingSelectionToModel_ = false;
        }
    }

    public void clear() {
        this.frame_.clear();
    }

    public void setAddJustificationsSectionVisibility(boolean isVisible) {
        this.frame_.setAddJustificationsSectionVisibility(isVisible);
    }

    public boolean getAddJustificationsSectionVisibility() {
        return this.frame_.getAddJustificationsSectionVisibility();
    }

    @Override
    public void axiomAdded(AxiomSelectionModel source, OWLAxiom axiom) {
        System.out.println("SEL: " + axiom);
    }

    @Override
    public void axiomRemoved(AxiomSelectionModel source, OWLAxiom axiom) {
    }

    private void handleMoveUp() {
        OWLAxiom selectedAxiom = this.getSelectedAxiom();
        if (selectedAxiom == null) {
            return;
        }
        JustificationFormattingManager formattingManager = JustificationFormattingManager.getInstance();
        boolean hasMoved = formattingManager.moveAxiomUp(this.manager_.getEntailment(), this.getSelectedJustification(), selectedAxiom);
        int selIndex = this.getSelectedIndex();
        this.getFrame().setRootObject((Object)((Explanation)this.getRootObject()));
        this.setSelectedIndex(selIndex - (hasMoved ? 1 : 0));
    }

    private void handleMoveDown() {
        OWLAxiom selectedAxiom = this.getSelectedAxiom();
        if (selectedAxiom == null) {
            return;
        }
        JustificationFormattingManager formattingManager = JustificationFormattingManager.getInstance();
        boolean hasMoved = formattingManager.moveAxiomDown(this.manager_.getEntailment(), this.getSelectedJustification(), selectedAxiom);
        int selIndex = this.getSelectedIndex();
        this.getFrame().setRootObject((Object)((Explanation)this.getRootObject()));
        this.setSelectedIndex(selIndex + (hasMoved ? 1 : 0));
    }

    private void handleIncreaseIndentation() {
        OWLAxiom selectedAxiom = this.getSelectedAxiom();
        if (selectedAxiom == null) {
            return;
        }
        JustificationFormattingManager formattingManager = JustificationFormattingManager.getInstance();
        formattingManager.increaseIndentation(this.manager_.getEntailment(), this.getSelectedJustification(), selectedAxiom);
        int selIndex = this.getSelectedIndex();
        this.getFrame().setRootObject((Object)((Explanation)this.getRootObject()));
        this.setSelectedIndex(selIndex);
    }

    private void handleDecreaseIndentation() {
        OWLAxiom selectedAxiom = this.getSelectedAxiom();
        if (selectedAxiom == null) {
            return;
        }
        JustificationFormattingManager formattingManager = JustificationFormattingManager.getInstance();
        formattingManager.decreaseIndentation(this.manager_.getEntailment(), this.getSelectedJustification(), selectedAxiom);
        int selIndex = this.getSelectedIndex();
        this.getFrame().setRootObject((Object)((Explanation)this.getRootObject()));
        this.setSelectedIndex(selIndex);
    }

    private OWLAxiom getSelectedAxiom() {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex == -1) {
            return null;
        }
        Object element = this.getModel().getElementAt(selectedIndex);
        if (!(element instanceof JustificationFrameSectionRow)) {
            return null;
        }
        return ((JustificationFrameSectionRow)((Object)element)).getAxiom();
    }

    private PrioritizedJustification getSelectedJustification() {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex == -1) {
            return null;
        }
        Object element = this.getModel().getElementAt(selectedIndex);
        if (!(element instanceof JustificationFrameSectionRow)) {
            return null;
        }
        return ((JustificationFrameSection)((JustificationFrameSectionRow)((Object)element)).getFrameSection()).getJustification();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Color oldColor = g.getColor();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(oldColor);
    }

    protected List<MListButton> getButtons(Object value) {
        if (value instanceof JustificationFrameSectionRow) {
            if (((JustificationFrameSectionRow)((Object)value)).getButtons() == null) {
                ((JustificationFrameSectionRow)((Object)value)).setButtons(this.createAxiomsRowButtons());
            }
            return ((JustificationFrameSectionRow)((Object)value)).getButtons();
        }
        if (value instanceof MListSectionHeader && value instanceof AddJustificationsSection) {
            return Collections.singletonList(((AddJustificationsSection)((Object)value)).getButton());
        }
        if (value instanceof MListSectionHeader && value instanceof JustificationStatusSection) {
            return Collections.singletonList(((JustificationStatusSection)((Object)value)).getButton());
        }
        return Collections.emptyList();
    }

    public void addToPopupMenu(OWLFrameListPopupMenuAction<Explanation> justificationOWLFrameListPopupMenuAction) {
    }

    protected Color getItemBackgroundColor(MListItem item) {
        if (item instanceof JustificationFrameSectionRow) {
            JustificationFrameSectionRow row = (JustificationFrameSectionRow)item;
            OWLAxiom axiom = row.getAxiom();
            if (row.isInferred()) {
                return INFERRED_BG_COLOR_;
            }
            int rowIndex = row.getFrameSection().getRowIndex((OWLFrameSectionRow)row) + 1;
            if (!this.isSelectedIndex(rowIndex) && this.axiomSelectionModel_.getSelectedAxioms().contains(axiom)) {
                return HIGHLIGHT_COLOR_;
            }
        }
        return super.getItemBackgroundColor(item);
    }

    protected List<MListButton> getListItemButtons(MListItem item) {
        if (item instanceof JustificationFrameSectionRow) {
            if (((JustificationFrameSectionRow)item).getButtons() == null) {
                ((JustificationFrameSectionRow)item).setButtons(this.createAxiomsRowButtons());
            }
            return ((JustificationFrameSectionRow)item).getButtons();
        }
        return Collections.emptyList();
    }

    private List<MListButton> createAxiomsRowButtons() {
        return Arrays.asList(new ExplainButton((ActionListener)new AbstractAction(){
            private static final long serialVersionUID = 4860966076807447714L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JustificationFrameList.this.invokeExplanationHandler();
            }
        }));
    }

    protected Border createListItemBorder(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof JustificationFrameSectionRow) {
            Insets insets = super.createListItemBorder(list, value, index, isSelected, cellHasFocus).getBorderInsets((Component)((Object)this));
            return BorderFactory.createMatteBorder(insets.top, ((JustificationFrameSectionRow)((Object)value)).getDepth() * 30, insets.bottom, insets.right, list.getBackground());
        }
        return super.createListItemBorder(list, value, index, isSelected, cellHasFocus);
    }

    public String getToolTipText(MouseEvent event) {
        if (event == null) {
            return super.getToolTipText();
        }
        Point location = event.getPoint();
        int index = this.locationToIndex(location);
        if (index < 0 || !this.getCellBounds(index, index).contains(location)) {
            return super.getToolTipText();
        }
        Object element = this.getModel().getElementAt(index);
        if (element instanceof JustificationFrameSectionRow) {
            return this.getPopularityString((JustificationFrameSectionRow)((Object)element));
        }
        if (element instanceof AddJustificationsSection) {
            return ((AddJustificationsSection)((Object)element)).getToolTipText();
        }
        if (element instanceof JustificationStatusSection) {
            return "Recompute justifications";
        }
        return super.getToolTipText(event);
    }

    private String getPopularityString(JustificationFrameSectionRow row) {
        int popularity = this.manager_.getPopularity(row.getAxiom());
        int count = this.justificationPanel_.getDisplayedJustificationCount() + this.manager_.getRemainingJustificationCount();
        if (popularity == 1) {
            return "Axiom appears only in THIS justification";
        }
        if (popularity == count) {
            return "Axiom appears in ALL justifications";
        }
        return String.format("Axiom appears in %s justifications", popularity);
    }
}

