/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.protege.explanation.justification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.liveontologies.protege.explanation.justification.AxiomSelectionListener;
import org.liveontologies.protege.explanation.justification.AxiomSelectionModel;
import org.protege.editor.core.Disposable;
import org.semanticweb.owlapi.model.OWLAxiom;

public class AxiomSelectionModelImpl
implements AxiomSelectionModel,
Disposable {
    private final Set<OWLAxiom> selectedAxioms_ = new HashSet<OWLAxiom>();
    private final List<AxiomSelectionListener> listeners_ = new ArrayList<AxiomSelectionListener>();

    @Override
    public void clearSelection() {
        while (this.selectedAxioms_.size() > 0) {
            this.setAxiomSelected(this.selectedAxioms_.iterator().next(), false);
        }
    }

    @Override
    public void setAxiomSelected(OWLAxiom axiom, boolean b) {
        if (b) {
            if (!this.selectedAxioms_.contains(axiom)) {
                this.selectedAxioms_.add(axiom);
                this.fireEvent(axiom, true);
            }
        } else if (this.selectedAxioms_.contains(axiom)) {
            this.selectedAxioms_.remove(axiom);
            this.fireEvent(axiom, false);
        }
    }

    protected void fireEvent(OWLAxiom axiom, boolean added) {
        for (AxiomSelectionListener listener : new ArrayList<AxiomSelectionListener>(this.listeners_)) {
            if (added) {
                listener.axiomAdded(this, axiom);
                continue;
            }
            listener.axiomRemoved(this, axiom);
        }
    }

    @Override
    public Set<OWLAxiom> getSelectedAxioms() {
        return Collections.unmodifiableSet(this.selectedAxioms_);
    }

    @Override
    public void addAxiomSelectionListener(AxiomSelectionListener lsnr) {
        this.listeners_.add(lsnr);
    }

    @Override
    public void removeAxiomSelectionListener(AxiomSelectionListener lsnr) {
        this.listeners_.remove(lsnr);
    }

    public void dispose() {
        while (this.listeners_.size() != 0) {
            this.removeAxiomSelectionListener(this.listeners_.get(0));
        }
    }
}

