package org.liveontologies.protege.explanation.justification;

/*-
 * #%L
 * Protege Justification Explanation
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2016 - 2017 Live Ontologies Project
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.util.Set;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

import org.liveontologies.protege.explanation.justification.service.JustificationComputation.InterruptMonitor;
import org.protege.editor.core.ProtegeManager;
import org.protege.editor.owl.OWLEditorKit;
import org.semanticweb.owlapi.model.OWLAxiom;

/**
 * Author: Matthew Horridge Stanford University Bio-Medical Informatics Research
 * Group Date: 20/03/2012
 */

public class ExplanationGeneratorProgressDialog extends JDialog
		implements JustificationComputationListener, InterruptMonitor {

	private static final long serialVersionUID = 2729423646823799401L;
	private final JustificationProgressPanel panel_;

	public ExplanationGeneratorProgressDialog(OWLEditorKit editorKit) {
		this(ProtegeManager.getInstance().getFrame(editorKit.getWorkspace()));
	}

	public ExplanationGeneratorProgressDialog(Frame owner) {
		super(owner, "Computing explanations", true);
		panel_ = new JustificationProgressPanel();
		setContentPane(panel_);
		pack();
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension dlgSize = getSize();
		setLocation(screenSize.width / 2 - dlgSize.width / 2,
				screenSize.height / 2 - dlgSize.height / 2);
		setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
	}

	public void reset() {
		panel_.reset();
	}

	@Override
	public void justificationFound(Set<OWLAxiom> justification) {
		panel_.justificationFound(justification);
	}

	@Override
	public void computationStarted() {
		panel_.reset();
		SwingUtilities.invokeLater(() -> setVisible(true));
	}

	@Override
	public void computationFinished() {
		panel_.clearInterrupt();
		SwingUtilities.invokeLater(() -> setVisible(false));
	}

	@Override
	public boolean isInterrupted() {
		return panel_.isInterrupted();
	}
}