/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.commom.xmpp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.SocketFactory;
import javax.security.auth.login.CredentialException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.RosterPacket;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smackx.packet.VCard;
import org.jivesoftware.smackx.provider.VCardProvider;
import org.littleshoot.commom.xmpp.GenericIQProvider;
import org.littleshoot.commom.xmpp.PasswordCredentials;
import org.littleshoot.commom.xmpp.XmppConfig;
import org.littleshoot.commom.xmpp.XmppConnectionRetyStrategy;
import org.littleshoot.commom.xmpp.XmppCredentials;
import org.littleshoot.commom.xmpp.XmppP2PClient;
import org.littleshoot.dnssec4j.VerifiedAddressFactory;
import org.littleshoot.util.xml.XPathUtils;
import org.littleshoot.util.xml.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlPullParser;

public class XmppUtils {
    private static final Logger LOG = LoggerFactory.getLogger(XmppUtils.class);
    private static ConnectionConfiguration globalConfig;
    private static ConnectionConfiguration globalProxyConfig;
    private static final Map<String, XMPPConnection> xmppConnections;
    private static ExecutorService connectors;

    private XmppUtils() {
    }

    public static Collection<InetSocketAddress> extractStunServers(String xml) {
        Document doc;
        LOG.info("Processing XML: {}", (Object)xml);
        ArrayList<InetSocketAddress> servers = new ArrayList<InetSocketAddress>(12);
        try {
            doc = XmlUtils.toDoc((String)xml);
        }
        catch (IOException e) {
            LOG.warn("Could not lookup Google STUN servers");
            return Collections.emptyList();
        }
        catch (SAXException e) {
            LOG.warn("Could not lookup Google STUN servers");
            return Collections.emptyList();
        }
        XPathUtils xpath = XPathUtils.newXPath((Document)doc);
        String str = "/iq/query/stun/server";
        try {
            NodeList nodes = xpath.getNodes("/iq/query/stun/server");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                NamedNodeMap nnm = node.getAttributes();
                Node hostNode = nnm.getNamedItem("host");
                Node portNode = nnm.getNamedItem("udp");
                if (hostNode == null || portNode == null) continue;
                String host = hostNode.getNodeValue();
                String port = portNode.getNodeValue();
                if (StringUtils.isBlank((String)host) || StringUtils.isBlank((String)port)) continue;
                servers.add(new InetSocketAddress(host, Integer.parseInt(port)));
            }
            LOG.info("Returning servers...");
            return servers;
        }
        catch (XPathExpressionException e) {
            LOG.error("XPath error", (Throwable)e);
            throw new Error("Tested XPath no longer working: /iq/query/stun/server", e);
        }
    }

    public static String extractSdp(Document doc) {
        return XmppUtils.extractXmppProperty(doc, "S");
    }

    public static long extractTransactionId(Document doc) {
        String id = XmppUtils.extractXmppProperty(doc, "TID");
        return Long.parseLong(id);
    }

    public static String extractFrom(Document doc) {
        String xml = XmlUtils.toString((Document)doc);
        LOG.info("Got an XMPP message: {}", (Object)xml);
        XPathUtils xpath = XPathUtils.newXPath((Document)doc);
        String str = "/message/From";
        try {
            return xpath.getString("/message/From");
        }
        catch (XPathExpressionException e) {
            throw new Error("Tested XPath no longer working: /message/From", e);
        }
    }

    private static String extractXmppProperty(Document doc, String name) {
        XPathUtils xpath = XPathUtils.newXPath((Document)doc);
        String str = "/message/properties/property[name='" + name + "']/value";
        try {
            return xpath.getString(str);
        }
        catch (XPathExpressionException e) {
            throw new Error("Tested XPath no longer working: " + str, e);
        }
    }

    public static void printMessage(Packet msg) {
        LOG.info(XmppUtils.toString(msg));
    }

    public static String toString(Packet msg) {
        XMPPError error = msg.getError();
        StringBuilder sb = new StringBuilder();
        sb.append("\nMESSAGE: ");
        sb.append("\nBODY: ");
        if (msg instanceof Message) {
            sb.append(((Message)msg).getBody());
        }
        sb.append("\nFROM: ");
        sb.append(msg.getFrom());
        sb.append("\nTO: ");
        sb.append(msg.getTo());
        sb.append("\nSUBJECT: ");
        if (msg instanceof Message) {
            sb.append(((Message)msg).getSubject());
        }
        sb.append("\nPACKET ID: ");
        sb.append(msg.getPacketID());
        sb.append("\nERROR: ");
        if (error != null) {
            sb.append(error);
            sb.append("\nCODE: ");
            sb.append(error.getCode());
            sb.append("\nMESSAGE: ");
            sb.append(error.getMessage());
            sb.append("\nCONDITION: ");
            sb.append(error.getCondition());
            sb.append("\nEXTENSIONS: ");
            sb.append(error.getExtensions());
            sb.append("\nTYPE: ");
            sb.append(error.getType());
        }
        sb.append("\nEXTENSIONS: ");
        sb.append(msg.getExtensions());
        sb.append("\nTYPE: ");
        if (msg instanceof Message) {
            sb.append(((Message)msg).getType());
        }
        sb.append("\nPROPERTY NAMES: ");
        sb.append(msg.getPropertyNames());
        return sb.toString();
    }

    static XMPPConnection persistentXmppConnection(String username, String password, String id) throws IOException, CredentialException {
        return XmppUtils.persistentXmppConnection(username, password, id, 4);
    }

    public static XMPPConnection persistentXmppConnection(String username, String password, String id, int attempts) throws IOException, CredentialException {
        return XmppUtils.persistentXmppConnection(username, password, id, attempts, "talk.google.com", 5222, "gmail.com", null);
    }

    public static XMPPConnection persistentXmppConnection(String username, String password, String id, int attempts, String host, int port, String serviceName, XmppP2PClient clientListener) throws IOException, CredentialException {
        return XmppUtils.persistentXmppConnection(new PasswordCredentials(username, password, id), attempts, host, port, serviceName, clientListener);
    }

    public static XMPPConnection persistentXmppConnection(XmppCredentials credentials, int attempts, String host, int port, String serviceName, XmppP2PClient clientListener) throws IOException, CredentialException {
        String key = credentials.getKey();
        if (xmppConnections.containsKey(key)) {
            XMPPConnection conn = xmppConnections.get(key);
            if (XmppUtils.isEstablished(conn)) {
                LOG.info("Returning existing xmpp connection");
                return conn;
            }
            LOG.info("Removing stale connection");
            xmppConnections.remove(key);
        }
        XMPPException exc = null;
        XmppConnectionRetyStrategy strategy = XmppConfig.newRetyStrategy();
        while (strategy.retry()) {
            try {
                LOG.debug("Attempting XMPP connection...");
                XMPPConnection conn = XmppUtils.singleXmppConnection(credentials, host, port, serviceName, clientListener);
                LOG.debug("Created offerer");
                xmppConnections.put(key, conn);
                return conn;
            }
            catch (XMPPException e) {
                LOG.error("Error creating XMPP connection", (Throwable)e);
                exc = e;
                strategy.sleep();
            }
        }
        if (exc != null) {
            throw new IOException("Could not log in!!", exc);
        }
        throw new IOException("Could not log in?");
    }

    private static boolean isEstablished(XMPPConnection conn) {
        return conn.isAuthenticated() && conn.isConnected();
    }

    private static InetAddress getHost(String host) throws UnknownHostException {
        return VerifiedAddressFactory.newVerifiedInetAddress((String)host, (boolean)XmppConfig.isUseDnsSec());
    }

    public static void setGlobalConfig(ConnectionConfiguration config) {
        globalConfig = config;
    }

    public static ConnectionConfiguration getGlobalConfig() {
        return globalConfig;
    }

    public static void setGlobalProxyConfig(ConnectionConfiguration config) {
        globalProxyConfig = config;
    }

    public static ConnectionConfiguration getGlobalProxyConfig() {
        return globalProxyConfig;
    }

    public static XMPPConnection simpleGoogleTalkConnection(String username, String password, String id) throws CredentialException, XMPPException, IOException {
        return XmppUtils.simpleGoogleTalkConnection(new PasswordCredentials(username, password, id));
    }

    public static XMPPConnection simpleGoogleTalkConnection(XmppCredentials credentials) throws CredentialException, XMPPException, IOException {
        return XmppUtils.singleXmppConnection(credentials, "talk.google.com", 5222, "gmail.com", null);
    }

    private static XMPPConnection singleXmppConnection(XmppCredentials credentials, String xmppServerHost, int xmppServerPort, String xmppServiceName, XmppP2PClient clientListener) throws XMPPException, CredentialException, IOException {
        LOG.debug("Creating single connection with direct config...");
        ConnectionConfiguration config = XmppUtils.getGlobalConfig() != null ? XmppUtils.getGlobalConfig() : XmppUtils.newConfig(XmppUtils.getHost(xmppServerHost), xmppServerPort, xmppServiceName);
        return XmppUtils.singleXmppConnection(credentials, xmppServerHost, xmppServerPort, xmppServiceName, clientListener, config);
    }

    private static XMPPConnection singleXmppConnection(final XmppCredentials credentials, String xmppServerHost, int xmppServerPort, String xmppServiceName, final XmppP2PClient clientListener, final ConnectionConfiguration config) throws XMPPException, CredentialException, IOException {
        LOG.debug("Creating single connection...");
        Future<XMPPConnection> fut = connectors.submit(new Callable<XMPPConnection>(){

            @Override
            public XMPPConnection call() throws Exception {
                return XmppUtils.newConnection(credentials, config, clientListener);
            }
        });
        try {
            XMPPConnection conn = fut.get(60L, TimeUnit.SECONDS);
            XmppUtils.getSharedStatus(conn);
            return conn;
        }
        catch (InterruptedException e) {
            LOG.debug("Interrupted exception", (Throwable)e);
            throw new IOException("Interrupted during login!!", e);
        }
        catch (ExecutionException e) {
            LOG.debug("Execution error connecting", (Throwable)e);
            Throwable cause = e.getCause();
            LOG.debug("Cause", cause);
            LOG.debug("Cause class: " + cause.getClass());
            if (cause instanceof XMPPException) {
                LOG.debug("Processing XMPPException...");
                String msg = cause.getMessage();
                LOG.debug("Got cause message: " + msg);
                if (msg.startsWith("XMPPError connecting")) {
                    LOG.debug("Trying backup server with XMPPException...");
                    return XmppUtils.singleXmppConnection(credentials, xmppServerHost, xmppServerPort, xmppServiceName, clientListener, XmppUtils.getProxyConfig(config, cause));
                }
                if (msg.startsWith("Could not connect")) {
                    LOG.debug("Trying backup server with XMPPException 'Could not connect'..");
                    return XmppUtils.singleXmppConnection(credentials, xmppServerHost, xmppServerPort, xmppServiceName, clientListener, XmppUtils.getProxyConfig(config, cause));
                }
                throw (XMPPException)cause;
            }
            if (cause instanceof UnknownHostException) {
                LOG.debug("Trying backup server...");
                return XmppUtils.singleXmppConnection(credentials, xmppServerHost, xmppServerPort, xmppServiceName, clientListener, XmppUtils.getProxyConfig(config, cause));
            }
            if (cause instanceof IOException) {
                LOG.debug("Trying backup server...");
                return XmppUtils.singleXmppConnection(credentials, xmppServerHost, xmppServerPort, xmppServiceName, clientListener, XmppUtils.getProxyConfig(config, cause));
            }
            if (cause instanceof IllegalStateException) {
                LOG.debug("Trying backup server...");
                return XmppUtils.singleXmppConnection(credentials, xmppServerHost, xmppServerPort, xmppServiceName, clientListener, XmppUtils.getProxyConfig(config, cause));
            }
            if (cause instanceof CredentialException) {
                throw (CredentialException)cause;
            }
            throw new IllegalStateException("Unrecognized cause", cause);
        }
        catch (TimeoutException e) {
            LOG.info("Timeout exception", (Throwable)e);
            throw new IOException("Took too long to login!!", e);
        }
    }

    private static ConnectionConfiguration getProxyConfig(ConnectionConfiguration config, Throwable t) throws IOException {
        if (config.getProxy().getProxyType() == ProxyInfo.ProxyType.HTTP) {
            LOG.debug("Config has proxy -- already tried proxy: {}", (Object)(config.getProxy().getProxyAddress() + ":" + config.getProxy().getProxyPort()));
            throw new IOException("Already tried proxy", t);
        }
        ConnectionConfiguration proxyConfig = XmppUtils.getGlobalProxyConfig();
        if (proxyConfig == null) {
            LOG.debug("Null global proxy config");
            throw new IOException("Could not use backup proxy", t);
        }
        if (proxyConfig.getProxy() == null) {
            LOG.debug("Null proxy in global proxy config");
            throw new IOException("Proxy config has no proxy!", t);
        }
        LOG.debug("Returning proxy config");
        return proxyConfig;
    }

    private static ConnectionConfiguration newConfig(InetAddress server, int xmppServerPort, String xmppServiceName) {
        ConnectionConfiguration config = new ConnectionConfiguration(server.getHostAddress(), xmppServerPort, xmppServiceName);
        config.setExpiredCertificatesCheckEnabled(true);
        config.setNotMatchingDomainCheckEnabled(true);
        config.setSendPresence(false);
        config.setCompressionEnabled(true);
        config.setReconnectionAllowed(false);
        config.setVerifyChainEnabled(true);
        config.setSelfSignedCertificateEnabled(false);
        config.setSocketFactory(new SocketFactory(){

            @Override
            public Socket createSocket(InetAddress host, int port, InetAddress localHost, int localPort) throws IOException {
                return this.createSocket(host, port);
            }

            @Override
            public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
                return this.createSocket(host, port);
            }

            @Override
            public Socket createSocket(InetAddress host, int port) throws IOException {
                LOG.info("Creating socket");
                Socket sock = new Socket();
                sock.connect(new InetSocketAddress(host, port), 40000);
                LOG.info("Socket connected");
                return sock;
            }

            @Override
            public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
                LOG.info("Creating socket");
                return this.createSocket(InetAddress.getByName(host), port);
            }
        });
        return config;
    }

    private static XMPPConnection newConnection(XmppCredentials credentials, ConnectionConfiguration config, final XmppP2PClient clientListener) throws XMPPException, CredentialException {
        config.setSecurityMode(ConnectionConfiguration.SecurityMode.required);
        XMPPConnection conn = credentials.createConnection(config);
        conn.connect();
        conn.addConnectionListener(new ConnectionListener(){

            public void reconnectionSuccessful() {
                LOG.debug("Reconnection successful...");
            }

            public void reconnectionFailed(Exception e) {
                LOG.debug("Reconnection failed", (Throwable)e);
            }

            public void reconnectingIn(int time) {
                LOG.debug("Reconnecting to XMPP server in " + time);
            }

            public void connectionClosedOnError(Exception e) {
                LOG.warn("XMPP connection closed on error", (Throwable)e);
                this.handleClose();
            }

            public void connectionClosed() {
                LOG.debug("XMPP connection closed. Creating new connection.");
                this.handleClose();
            }

            private void handleClose() {
                if (clientListener != null) {
                    clientListener.handleClose();
                }
            }
        });
        LOG.debug("Connection is Secure: {}", (Object)conn.isSecureConnection());
        LOG.debug("Connection is TLS: {}", (Object)conn.isUsingTLS());
        try {
            credentials.login(conn);
        }
        catch (XMPPException e) {
            String msg = e.getMessage();
            if (msg != null && msg.contains("No response from the server")) {
                throw e;
            }
            LOG.debug("Credentials error!", (Throwable)e);
            throw new CredentialException("Authentication error");
        }
        while (!XmppUtils.isEstablished(conn)) {
            LOG.debug("Waiting for authentication");
            try {
                Thread.sleep(80L);
            }
            catch (InterruptedException e1) {
                LOG.error("Exception during sleep?", (Throwable)e1);
            }
        }
        LOG.debug("Returning connection...");
        return conn;
    }

    public static String jidToUser(String jid) {
        return StringUtils.substringBefore((String)jid, (String)"/");
    }

    public static String jidToUser(XMPPConnection conn) {
        return XmppUtils.jidToUser(conn.getUser());
    }

    public static VCard getVCard(XMPPConnection conn, String emailId) throws XMPPException {
        VCard card = new VCard();
        card.load((Connection)conn, emailId);
        return card;
    }

    public static Packet goOffTheRecord(String jidToOtr, XMPPConnection conn) {
        LOG.debug("Activating OTR for {}...", (Object)jidToOtr);
        String query = "<query xmlns='google:nosave'><item xmlns='google:nosave' jid='" + jidToOtr + "' value='enabled'/>" + "</query>";
        return XmppUtils.setGTalkProperty(conn, query);
    }

    public static Packet goOnTheRecord(String jidToOtr, XMPPConnection conn) {
        LOG.debug("Activating OTR for {}...", (Object)jidToOtr);
        String query = "<query xmlns='google:nosave'><item xmlns='google:nosave' jid='" + jidToOtr + "' value='disabled'/>" + "</query>";
        return XmppUtils.setGTalkProperty(conn, query);
    }

    public static Packet getOtr(XMPPConnection conn) {
        LOG.debug("Getting OTR status...");
        return XmppUtils.getGTalkProperty(conn, "<query xmlns='google:nosave'/>");
    }

    public static Packet getSharedStatus(XMPPConnection conn) {
        LOG.debug("Getting shared status...");
        return XmppUtils.getGTalkProperty(conn, "<query xmlns='google:shared-status' version='2'/>");
    }

    public static RosterPacket extendedRoster(XMPPConnection conn) {
        LOG.debug("Requesting extended roster");
        String query = "<query xmlns:gr='google:roster' gr:ext='2' xmlns='jabber:iq:roster'/>";
        return (RosterPacket)XmppUtils.getGTalkProperty(conn, "<query xmlns:gr='google:roster' gr:ext='2' xmlns='jabber:iq:roster'/>");
    }

    public static Collection<InetSocketAddress> googleStunServers(XMPPConnection conn) {
        LOG.debug("Getting Google STUN servers...");
        Packet pack = XmppUtils.getGTalkProperty(conn, "<query xmlns='google:jingleinfo'/>");
        if (pack == null) {
            LOG.warn("Did not get response to Google stun server request!");
            return Collections.emptyList();
        }
        return XmppUtils.extractStunServers(pack.toXML());
    }

    public static Packet discoveryRequest(XMPPConnection conn) {
        LOG.debug("Sending discovery request...");
        return XmppUtils.getGTalkProperty(conn, "<query xmlns='http://jabber.org/protocol/disco#info'/>");
    }

    private static Packet setGTalkProperty(XMPPConnection conn, String query) {
        return XmppUtils.sendXmppMessage(conn, query, IQ.Type.SET);
    }

    private static Packet getGTalkProperty(XMPPConnection conn, String query) {
        return XmppUtils.sendXmppMessage(conn, query, IQ.Type.GET);
    }

    private static Packet sendXmppMessage(XMPPConnection conn, final String query, IQ.Type iqType) {
        LOG.debug("Sending XMPP stanza message...");
        IQ iq = new IQ(){

            public String getChildElementXML() {
                return query;
            }
        };
        String jid = conn.getUser();
        iq.setTo(XmppUtils.jidToUser(jid));
        iq.setFrom(jid);
        iq.setType(iqType);
        PacketCollector collector = conn.createPacketCollector((PacketFilter)new PacketIDFilter(iq.getPacketID()));
        LOG.debug("Sending XMPP stanza packet:\n" + iq.toXML());
        conn.sendPacket((Packet)iq);
        Packet response = collector.nextResult(40000L);
        return response;
    }

    public static void setGoogleTalkInvisible(XMPPConnection conn, String to) {
        IQ iq = new IQ(){

            public String getChildElementXML() {
                return "<query xmlns='google:shared-status' version='2'><invisible value='true'/></query>";
            }
        };
        iq.setType(IQ.Type.SET);
        iq.setTo(to);
        LOG.debug("Setting invisible with XML packet:\n" + iq.toXML());
        conn.sendPacket((Packet)iq);
    }

    static {
        ProviderManager.getInstance().addIQProvider("vCard", "vcard-temp", (Object)new VCardProvider());
        ProviderManager.getInstance().addIQProvider("query", "google:shared-status", (Object)new GenericIQProvider(){

            @Override
            public IQ parseIQ(XmlPullParser parser) throws Exception {
                return super.parseIQ(parser);
            }
        });
        ProviderManager.getInstance().addIQProvider("query", "google:nosave", (Object)new GenericIQProvider());
        ProviderManager.getInstance().addIQProvider("query", "http://jabber.org/protocol/disco#info", (Object)new GenericIQProvider());
        ProviderManager.getInstance().addIQProvider("query", "google:jingleinfo", (Object)new GenericIQProvider());
        xmppConnections = new ConcurrentHashMap<String, XMPPConnection>();
        connectors = Executors.newCachedThreadPool(new ThreadFactory(){
            private int count = 0;

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "XMPP-Connecting-Thread-" + this.count);
                t.setDaemon(true);
                ++this.count;
                return t;
            }
        });
    }

    private static interface ConnectionHandler {
        public void setupConnection(XMPPConnection var1);

        public void login(XMPPConnection var1) throws XMPPException;
    }
}

