/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.commom.xmpp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.prefs.Preferences;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.io.IOExceptionWithCause;
import org.lastbamboo.common.offer.answer.NoAnswerException;
import org.lastbamboo.common.p2p.SocketFactory;
import org.littleshoot.commom.xmpp.DefaultXmppUriFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmppProtocolSocketFactory
implements ProtocolSocketFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SocketFactory<Socket> socketFactory;
    private final DefaultXmppUriFactory xmppUriFactory;

    public XmppProtocolSocketFactory(SocketFactory<Socket> socketFactory, DefaultXmppUriFactory defaultXmppUriFactory) {
        this.socketFactory = socketFactory;
        this.xmppUriFactory = defaultXmppUriFactory;
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        this.log.warn("Attempted unsupported socket call");
        throw new UnsupportedOperationException("not allowed");
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        return this.createSocket(host, port);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        this.log.trace("Creating a socket for user: {}", (Object)host);
        Preferences prefs = Preferences.userRoot();
        long id = prefs.getLong("LITTLESHOOT_ID", -1L);
        if (id == Long.parseLong(host)) {
            this.log.error("Ignoring request to download from ourselves...");
            throw new IOException("Not downloading from ourselves...");
        }
        URI uri = this.xmppUriFactory.createXmppUri(host);
        NoAnswerException nae = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.log.trace("About to create socket...");
                Socket sock = (Socket)this.socketFactory.newSocket(uri);
                this.log.debug("Got socket!! Returning to HttpClient");
                return sock;
            }
            catch (NoAnswerException e) {
                this.log.warn("Did not get answer! Trying again", (Throwable)e);
                nae = e;
                continue;
            }
            catch (IOException e) {
                this.log.warn("Exception creating P2P socket", (Throwable)e);
                throw e;
            }
        }
        throw new IOExceptionWithCause(nae);
    }
}

