/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.testing;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.testcontainers.containers.Neo4jContainer;
import org.testcontainers.utility.MountableFile;

public class TestNeo4jContainer
implements AutoCloseable {
    private final Neo4jContainer<?> container;

    private TestNeo4jContainer(boolean enterprise, String password) {
        this.container = TestNeo4jContainer.createContainer(TestNeo4jContainer.imageCoordinates(enterprise), password);
    }

    public static TestNeo4jContainer createCommunityNeo4jContainer(String adminPassword) {
        return new TestNeo4jContainer(false, adminPassword);
    }

    public static TestNeo4jContainer createEnterpriseNeo4jContainer(String adminPassword) {
        return new TestNeo4jContainer(true, adminPassword);
    }

    public String getBoltUrl() {
        return this.container.getBoltUrl();
    }

    public String getHttpUrl() {
        return this.container.getHttpUrl();
    }

    public String getHttpsUrl() {
        return this.container.getHttpsUrl();
    }

    public void start() {
        this.container.start();
    }

    public void stop() {
        this.container.stop();
    }

    @Override
    public void close() {
        this.container.close();
    }

    private static Neo4jContainer<?> createContainer(String coordinates, String adminPassword) {
        String extensionJarPath = TestNeo4jContainer.readSingleLine("/extensions.dir");
        if (!Files.isRegularFile(Paths.get(extensionJarPath, new String[0]), new LinkOption[0])) {
            throw new RuntimeException(String.format("Could get not start container, no extension JAR found at path %s.%nMake sure to build the testing module first.", extensionJarPath));
        }
        return ((Neo4jContainer)new Neo4jContainer(coordinates).withAdminPassword(adminPassword).withEnv("NEO4J_ACCEPT_LICENSE_AGREEMENT", "yes")).withPlugins(MountableFile.forHostPath((String)extensionJarPath));
    }

    private static String imageCoordinates(boolean enterprise) {
        String version = TestNeo4jContainer.projectNeo4jVersion();
        if (version.equals("latest") || version.equals("community")) {
            if (enterprise) {
                return "neo4j:enterprise";
            }
            return String.format("neo4j:%s", version);
        }
        return String.format("neo4j:%s%s", version, enterprise ? "-enterprise" : "");
    }

    private static String projectNeo4jVersion() {
        String neo4jVersion = System.getenv("NEO4J_VERSION");
        return neo4jVersion == null ? "latest" : neo4jVersion;
    }

    private static String readSingleLine(String filteredClasspathResource) {
        List<String> lines = TestNeo4jContainer.readLines(filteredClasspathResource);
        int lineCount = lines.size();
        if (lineCount != 1) {
            throw new RuntimeException(String.format("%s (filtered) resource should contain exactly 1 line, found: %d", filteredClasspathResource, lineCount));
        }
        return lines.iterator().next();
    }

    private static List<String> readLines(String classpathResource) {
        List<String> list;
        BufferedReader reader = new BufferedReader(new InputStreamReader(TestNeo4jContainer.class.getResourceAsStream(classpathResource)));
        try {
            list = reader.lines().collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return list;
    }
}

