/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.testing;

import java.util.Arrays;
import java.util.Collection;
import org.junit.After;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.liquigraph.testing.JdbcAwareGraphDatabase;
import org.slf4j.bridge.SLF4JBridgeHandler;

@RunWith(value=Parameterized.class)
public abstract class ParameterizedDatabaseIT {
    private static final JdbcAwareGraphDatabase communityGraphDatabase;
    private static final JdbcAwareGraphDatabase enterpriseGraphDatabase;
    protected final JdbcAwareGraphDatabase graphDb;
    protected final String uri;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> graphDbProvider() {
        communityGraphDatabase.ensureStarted();
        enterpriseGraphDatabase.ensureStarted();
        return Arrays.asList({"Community Edition - Bolt", communityGraphDatabase, communityGraphDatabase.boltJdbcUrl()}, {"Community Edition - HTTP", communityGraphDatabase, communityGraphDatabase.httpJdbcUrl()}, {"Enterprise Edition - Bolt", enterpriseGraphDatabase, enterpriseGraphDatabase.boltJdbcUrl()}, {"Enterprise Edition - HTTP", enterpriseGraphDatabase, enterpriseGraphDatabase.httpJdbcUrl()});
    }

    public ParameterizedDatabaseIT(String ignored, JdbcAwareGraphDatabase graphDb, String uri) {
        this.graphDb = graphDb;
        this.uri = uri;
    }

    @After
    public void cleanUp() {
        communityGraphDatabase.cleanUp();
        enterpriseGraphDatabase.cleanUp();
    }

    static {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        communityGraphDatabase = JdbcAwareGraphDatabase.createCommunityInstance();
        enterpriseGraphDatabase = JdbcAwareGraphDatabase.createEnterpriseInstance();
    }
}

