/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.testing;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import org.liquigraph.testing.TestNeo4jContainer;
import org.liquigraph.testing.ThrowingConsumer;

public class JdbcAwareGraphDatabase {
    private final Collection<Connection> connections = new ArrayList<Connection>();
    private final TestNeo4jContainer container;
    private final String adminPassword = "j4eon";

    private JdbcAwareGraphDatabase(boolean enterprise) {
        this.container = enterprise ? TestNeo4jContainer.createEnterpriseNeo4jContainer("j4eon") : TestNeo4jContainer.createCommunityNeo4jContainer("j4eon");
    }

    public static JdbcAwareGraphDatabase createCommunityInstance() {
        return new JdbcAwareGraphDatabase(false);
    }

    public static JdbcAwareGraphDatabase createEnterpriseInstance() {
        return new JdbcAwareGraphDatabase(true);
    }

    public JdbcAwareGraphDatabase commitNewSingleStatementConnection(String url, ThrowingConsumer<Statement, SQLException> statementConsumer) {
        return this.commitNewConnection(url, this.runSingleStatement(statementConsumer));
    }

    public JdbcAwareGraphDatabase commitNewConnection(String url, ThrowingConsumer<Connection, SQLException> connectionConsumer) {
        return this.doWithConnection(url, connectionConsumer.andThen(Connection::commit));
    }

    public JdbcAwareGraphDatabase rollbackNewSingleStatementConnection(String url, ThrowingConsumer<Statement, SQLException> statementConsumer) {
        return this.rollbackNewConnection(url, this.runSingleStatement(statementConsumer));
    }

    public JdbcAwareGraphDatabase rollbackNewConnection(String url, ThrowingConsumer<Connection, SQLException> connectionConsumer) {
        return this.doWithConnection(url, connectionConsumer.andThen(Connection::rollback));
    }

    private ThrowingConsumer<Connection, SQLException> runSingleStatement(ThrowingConsumer<Statement, SQLException> statementConsumer) {
        return connection -> {
            try (Statement statement = connection.createStatement();){
                statementConsumer.accept(statement);
            }
        };
    }

    public void ensureStarted() {
        this.container.start();
    }

    public Supplier<Connection> asConnectionSupplier(String uri) {
        return () -> this.newConnection(uri);
    }

    public String boltJdbcUrl() {
        return String.format("jdbc:neo4j:%s", this.container.getBoltUrl());
    }

    public String httpJdbcUrl() {
        return String.format("jdbc:neo4j:%s", this.container.getHttpUrl());
    }

    public Properties props() {
        Properties props = new Properties();
        this.username().ifPresent(user -> props.setProperty("user", (String)user));
        this.password().ifPresent(pw -> props.setProperty("password", (String)pw));
        return props;
    }

    public Optional<String> username() {
        return Optional.of("neo4j");
    }

    public Optional<String> password() {
        return Optional.of("j4eon");
    }

    public void cleanUp() {
        int openConnections = 0;
        try {
            this.emptyDatabase();
            for (Connection connection : this.connections) {
                if (connection.isClosed()) continue;
                ++openConnections;
                connection.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        if (openConnections != 0) {
            throw new RuntimeException(String.format("Connections remaining open: %d", openConnections));
        }
    }

    private void emptyDatabase() throws SQLException {
        Statement statement;
        try (Connection connection = this.newConnection(this.boltJdbcUrl());){
            statement = connection.createStatement();
            try {
                statement.execute("CALL clearDb()");
                connection.commit();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        connection = this.newConnection(this.boltJdbcUrl());
        try {
            statement = connection.createStatement();
            try {
                statement.execute("CALL clearSchema()");
                connection.commit();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private JdbcAwareGraphDatabase doWithConnection(String url, ThrowingConsumer<Connection, SQLException> connectionConsumer) {
        JdbcAwareGraphDatabase jdbcAwareGraphDatabase;
        block8: {
            Connection connection = this.newConnection(url);
            try {
                connectionConsumer.accept(connection);
                jdbcAwareGraphDatabase = this;
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            connection.close();
        }
        return jdbcAwareGraphDatabase;
    }

    private Connection newConnection(String uri) {
        try {
            Connection connection = DriverManager.getConnection(uri, this.props());
            connection.setAutoCommit(false);
            this.connections.add(connection);
            return connection;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

