/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.examples.spring;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@SpringBootApplication
@RestController
public class SampleController {
    private final DataSource dataSource;

    public SampleController(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @GetMapping(value={"/"}, produces={"text/plain"})
    String home() throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            String string;
            block13: {
                Statement statement = connection.createStatement();
                try {
                    if (!statement.execute("MATCH (n:Sentence) RETURN n.text AS result")) {
                        throw new RuntimeException("Could not execute query");
                    }
                    string = this.extract("result", statement.getResultSet());
                    if (statement == null) break block13;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return string;
        }
    }

    private String extract(String columnLabel, ResultSet results) throws SQLException {
        try (ResultSet resultSet = results;){
            resultSet.next();
            String string = resultSet.getString(columnLabel);
            return string;
        }
    }

    public static void main(String[] args) {
        SpringApplication.run(SampleController.class, (String[])args);
    }
}

