/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.io.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.liquigraph.core.io.xml.ChangelogParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

class SchemaErrorHandler
implements ErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangelogParser.class);
    private final List<String> errors = new ArrayList<String>();

    SchemaErrorHandler() {
    }

    public Collection<String> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    @Override
    public void warning(SAXParseException exception) {
        LOGGER.warn("XSD validation warning : {}", (Object)exception.getMessage());
    }

    @Override
    public void error(SAXParseException exception) {
        LOGGER.error("XSD validation error : {}", (Object)exception.getMessage());
        this.errors.add(exception.getMessage());
    }

    @Override
    public void fatalError(SAXParseException exception) {
        LOGGER.error("XSD validation fatal : {}", (Object)exception.getMessage());
        this.errors.add(exception.getMessage());
    }
}

