/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.io.xml;

import javax.xml.transform.dom.DOMSource;
import org.liquigraph.core.io.xml.NodeListIterator;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class SchemaDetector {
    SchemaDetector() {
    }

    public boolean hasExplicitSchema(DOMSource changelog) {
        Node node = changelog.getNode();
        if (node.getNodeType() == 9) {
            return this.hasExplicitSchema(this.rootElement(node));
        }
        return this.hasExplicitSchema(node);
    }

    private Node rootElement(Node document) {
        NodeListIterator iterator = new NodeListIterator(document.getChildNodes());
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node.getNodeType() != 1 || !node.getNodeName().equals("changelog")) continue;
            return node;
        }
        return null;
    }

    private boolean hasExplicitSchema(Node node) {
        if (node == null) {
            return false;
        }
        if (node.getNodeType() != 1) {
            return false;
        }
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return false;
        }
        return this.findAttributeByName(attributes, "xsi:noNamespaceSchemaLocation");
    }

    private boolean findAttributeByName(NamedNodeMap attributes, String name) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!name.equals(attributes.item(i).getNodeName())) continue;
            return true;
        }
        return false;
    }
}

