/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.configuration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Properties;
import org.liquigraph.core.configuration.ConnectionConfiguration;
import org.liquigraph.core.exception.Throwables;

public class ConnectionConfigurationByUri
implements ConnectionConfiguration {
    private final String uri;
    private final Properties properties;
    private final UriConnectionSupplier connectionSupplier;

    public ConnectionConfigurationByUri(String uri, Optional<String> database, Optional<String> username, Optional<String> password) {
        this(uri, database, username, password, DefaultUriConnectionSupplier.INSTANCE);
    }

    ConnectionConfigurationByUri(String uri, Optional<String> database, Optional<String> username, Optional<String> password, UriConnectionSupplier connectionSupplier) {
        this.uri = uri;
        this.connectionSupplier = connectionSupplier;
        this.properties = ConnectionConfigurationByUri.createProperties(database, username, password);
    }

    @Override
    public Connection get() {
        return this.connectionSupplier.getConnection(this.uri, this.properties);
    }

    private static Properties createProperties(Optional<String> database, Optional<String> username, Optional<String> password) {
        Properties props = new Properties();
        username.ifPresent(user -> props.setProperty("user", (String)user));
        password.ifPresent(pw -> props.setProperty("password", (String)pw));
        database.ifPresent(db -> props.setProperty("database", (String)db));
        return props;
    }

    static interface UriConnectionSupplier {
        public Connection getConnection(String var1, Properties var2);
    }

    private static enum DefaultUriConnectionSupplier implements UriConnectionSupplier
    {
        INSTANCE;


        @Override
        public Connection getConnection(String uri, Properties properties) {
            try {
                return DriverManager.getConnection(uri, properties);
            }
            catch (SQLException e) {
                throw Throwables.propagate(e);
            }
        }
    }
}

