/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.api;

import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.liquigraph.core.configuration.ExecutionContexts;
import org.liquigraph.core.model.Changeset;
import org.liquigraph.core.model.predicates.ChangesetChecksumHasChanged;
import org.liquigraph.core.model.predicates.ChangesetMatchAnyExecutionContexts;
import org.liquigraph.core.model.predicates.ChangesetRunAlways;
import org.liquigraph.core.model.predicates.ChangesetRunOnChange;
import org.liquigraph.core.model.predicates.Predicates;

class ChangelogDiffMaker {
    ChangelogDiffMaker() {
    }

    public Collection<Changeset> computeChangesetsToInsert(ExecutionContexts executionContexts, Collection<Changeset> declaredChangesets, Collection<Changeset> persistedChangesets) {
        return declaredChangesets.stream().filter(ChangesetMatchAnyExecutionContexts.BY_ANY_EXECUTION_CONTEXT(executionContexts)).filter(ChangelogDiffMaker.executionFilter(persistedChangesets)).collect(Collectors.toList());
    }

    private static Predicate<Changeset> executionFilter(Collection<Changeset> persistedChangesets) {
        return Predicates.in(persistedChangesets).negate().or(ChangesetRunOnChange.RUN_ON_CHANGE.and(ChangesetChecksumHasChanged.CHECKSUM_HAS_CHANGED(persistedChangesets))).or(ChangesetRunAlways.RUN_ALWAYS);
    }
}

