/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.liquigraph.core.model.Changeset;
import org.liquigraph.core.model.predicates.ChangesetById;
import org.liquigraph.core.model.predicates.ChangesetRunOnChange;

public class PersistedChangesetValidator {
    public Collection<String> validate(Collection<Changeset> declaredChangesets, Collection<Changeset> persistedChangesets) {
        List<Changeset> changesets = declaredChangesets.stream().filter(ChangesetRunOnChange.RUN_ON_CHANGE.negate()).collect(Collectors.toList());
        return this.validateChecksums(changesets, persistedChangesets);
    }

    private Collection<String> validateChecksums(Collection<Changeset> declaredChangesets, Collection<Changeset> persistedChangesets) {
        ArrayList<String> errors = new ArrayList<String>();
        for (Changeset declaredChangeset : declaredChangesets) {
            Optional<Changeset> maybePersistedChangeset = persistedChangesets.stream().filter(ChangesetById.BY_ID(declaredChangeset.getId(), declaredChangeset.getAuthor())).findFirst();
            if (!maybePersistedChangeset.isPresent()) continue;
            Changeset persistedChangeset = maybePersistedChangeset.get();
            String declaredChecksum = declaredChangeset.getChecksum();
            String persistedChecksum = persistedChangeset.getChecksum();
            if (persistedChecksum.equals(declaredChecksum)) continue;
            errors.add(this.checksumMismatchError(declaredChangeset, persistedChangeset));
        }
        return errors;
    }

    private String checksumMismatchError(Changeset declaredChangeset, Changeset persistedChangeset) {
        return String.format("Changeset with ID <%s> and author <%s> has conflicted checksums.%n\t - Declared: <%s>%n\t - Persisted: <%s>.", declaredChangeset.getId(), declaredChangeset.getAuthor(), declaredChangeset.getChecksum(), persistedChangeset.getChecksum());
    }
}

