/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.model.predicates;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import org.liquigraph.core.model.Changeset;
import org.liquigraph.core.model.predicates.ChangesetById;

public class ChangesetChecksumHasChanged
implements Predicate<Changeset> {
    private final Collection<Changeset> persistedChangesets;

    private ChangesetChecksumHasChanged(Collection<Changeset> persistedChangesets) {
        this.persistedChangesets = persistedChangesets;
    }

    public static Predicate<Changeset> CHECKSUM_HAS_CHANGED(Collection<Changeset> persistedChangesets) {
        return new ChangesetChecksumHasChanged(persistedChangesets);
    }

    @Override
    public boolean test(Changeset input) {
        Optional<Changeset> persistedChangeset = this.persistedChangesets.stream().filter(ChangesetById.BY_ID(input.getId(), input.getAuthor())).findFirst();
        return persistedChangeset.isPresent() && !input.getChecksum().equals(persistedChangeset.get().getChecksum());
    }
}

