/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.model;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import org.liquigraph.core.exception.Throwables;

public class Checksums {
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();

    public static String checksum(Collection<String> queries) {
        MessageDigest messageDigest = Checksums.sha1MessageDigest();
        for (String query : queries) {
            messageDigest.update(query.getBytes(StandardCharsets.UTF_8));
        }
        return Checksums.buildHexadecimalRepresentation(messageDigest.digest());
    }

    private static String buildHexadecimalRepresentation(byte[] bytes) {
        StringBuilder builder = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            builder.append(HEX_DIGITS[b >> 4 & 0xF]).append(HEX_DIGITS[b & 0xF]);
        }
        return builder.toString();
    }

    private static MessageDigest sha1MessageDigest() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw Throwables.propagate(e);
        }
    }
}

