/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.liquigraph.core.exception.Preconditions;
import org.liquigraph.core.model.Checksums;
import org.liquigraph.core.model.Postcondition;
import org.liquigraph.core.model.Precondition;

public class Changeset {
    private String id;
    private String author;
    private Collection<String> queries = new ArrayList<String>();
    private String checksum;
    private Collection<String> executionsContexts = new ArrayList<String>();
    private boolean runOnChange;
    private boolean runAlways;
    private Precondition precondition;
    private Postcondition postcondition;

    @XmlAttribute(name="id", required=true)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @XmlAttribute(name="author", required=true)
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @XmlElement(name="query", required=true)
    public Collection<String> getQueries() {
        return this.queries;
    }

    public void setQueries(Collection<String> queries) {
        Preconditions.checkArgument(queries != null, "Queries cannot be null");
        Preconditions.checkArgument(queries.size() > 0, "At least one query must be defined");
        this.queries = queries;
        this.setChecksum(Checksums.checksum(queries));
    }

    @XmlTransient
    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        Preconditions.checkArgument(checksum != null, "Checksum cannot be null");
        this.checksum = checksum;
    }

    @XmlTransient
    public Collection<String> getExecutionsContexts() {
        return this.executionsContexts;
    }

    @XmlAttribute(name="contexts", required=false)
    String getContexts() {
        return String.join((CharSequence)",", this.executionsContexts);
    }

    public void setContexts(String executionsContexts) {
        this.executionsContexts = Arrays.stream((executionsContexts == null ? "" : executionsContexts).split(",")).filter(s -> !s.isEmpty()).map(String::trim).collect(Collectors.toList());
    }

    @XmlAttribute(name="run-on-change", required=false)
    public boolean isRunOnChange() {
        return this.runOnChange;
    }

    public void setRunOnChange(boolean runOnChange) {
        this.runOnChange = runOnChange;
    }

    @XmlAttribute(name="run-always", required=false)
    public boolean isRunAlways() {
        return this.runAlways;
    }

    public void setRunAlways(boolean runAlways) {
        this.runAlways = runAlways;
    }

    @XmlElement(name="precondition", required=false)
    public Precondition getPrecondition() {
        return this.precondition;
    }

    public void setPrecondition(Precondition precondition) {
        this.precondition = precondition;
    }

    @XmlElement(name="postcondition", required=false)
    public Postcondition getPostcondition() {
        return this.postcondition;
    }

    public void setPostcondition(Postcondition postcondition) {
        this.postcondition = postcondition;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.author, this.checksum);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Changeset other = (Changeset)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.author, other.author) && Objects.equals(this.checksum, other.checksum);
    }

    public String toString() {
        return "Changeset{id='" + this.id + "', author='" + this.author + "', queries='" + this.queries + "', checksum='" + this.checksum + "', executionsContexts=" + this.executionsContexts + ", runOnChange=" + this.runOnChange + ", runAlways=" + this.runAlways + ", precondition=" + this.precondition + ", postcondition=" + this.postcondition + "}";
    }
}

