/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.io.xml;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class LiquigraphLocalEntityResolver
implements EntityResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Map<String, String> KNOWN_ENTITIES = new HashMap<String, String>();

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        LOGGER.trace("Resolving entity, public {}, system {}", (Object)publicId, (Object)systemId);
        if (KNOWN_ENTITIES.containsKey(systemId)) {
            return new InputSource(this.getClass().getClassLoader().getResourceAsStream(KNOWN_ENTITIES.get(systemId)));
        }
        return null;
    }

    static {
        KNOWN_ENTITIES.put("http://www.liquigraph.org/schema/1.0/liquigraph.xsd", "schema/1.0/liquigraph.xsd");
        KNOWN_ENTITIES.put("https://www.liquigraph.org/schema/1.0/liquigraph.xsd", "schema/1.0/liquigraph.xsd");
        KNOWN_ENTITIES.put("http://liquigraph.github.io/schema/1.0/liquigraph.xsd", "schema/1.0/liquigraph.xsd");
        KNOWN_ENTITIES.put("https://liquigraph.github.io/schema/1.0/liquigraph.xsd", "schema/1.0/liquigraph.xsd");
        KNOWN_ENTITIES.put("http://fbiville.github.io/liquigraph/schema/1.0/liquigraph.xsd", "schema/1.0/liquigraph.xsd");
        KNOWN_ENTITIES.put("https://fbiville.github.io/liquigraph/schema/1.0/liquigraph.xsd", "schema/1.0/liquigraph.xsd");
        KNOWN_ENTITIES.put("http://www.liquigraph.org/schema/1.0-RC3/liquigraph.xsd", "schema/1.0-RC3/liquigraph.xsd");
        KNOWN_ENTITIES.put("https://www.liquigraph.org/schema/1.0-RC3/liquigraph.xsd", "schema/1.0-RC3/liquigraph.xsd");
        KNOWN_ENTITIES.put("http://fbiville.github.io/liquigraph/schema/1.0-RC3/liquigraph.xsd", "schema/1.0-RC3/liquigraph.xsd");
        KNOWN_ENTITIES.put("https://fbiville.github.io/liquigraph/schema/1.0-RC3/liquigraph.xsd", "schema/1.0-RC3/liquigraph.xsd");
        KNOWN_ENTITIES.put("http://www.liquigraph.org/schema/changelog.xsd", "schema/changelog.xsd");
        KNOWN_ENTITIES.put("https://www.liquigraph.org/schema/changelog.xsd", "schema/changelog.xsd");
    }
}

