/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.io.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.liquigraph.core.io.xml.ChainedEntityResolver;
import org.liquigraph.core.io.xml.DomSourceValidator;
import org.liquigraph.core.io.xml.LiquigraphLocalEntityResolver;
import org.liquigraph.core.io.xml.RedirectAwareEntityResolver;
import org.liquigraph.core.io.xml.SchemaErrorHandler;
import org.liquigraph.core.io.xml.XmlSchemaValidator;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class ImplicitSchemaValidator
implements DomSourceValidator {
    private final Schema schema = ImplicitSchemaValidator.implicitSchema("/schema/changelog.xsd");

    @Override
    public Collection<String> validate(DOMSource source) throws Exception {
        SchemaErrorHandler errorHandler = new SchemaErrorHandler();
        this.validator(errorHandler).validate(source);
        return errorHandler.getErrors();
    }

    private static Schema implicitSchema(String name) {
        Schema schema;
        block8: {
            InputStream stream = XmlSchemaValidator.class.getResourceAsStream(name);
            try {
                schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new StreamSource(stream));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SAXException e) {
                    throw new IllegalStateException(e);
                }
            }
            stream.close();
        }
        return schema;
    }

    private Validator validator(SchemaErrorHandler customErrorHandler) {
        Validator validator = this.schema.newValidator();
        ChainedEntityResolver resolverChain = new ChainedEntityResolver();
        resolverChain.addEntityResolver(new LiquigraphLocalEntityResolver());
        resolverChain.addEntityResolver(new RedirectAwareEntityResolver());
        LSResourceResolver currentResolver = validator.getResourceResolver();
        validator.setResourceResolver((type, namespaceURI, publicId, systemId, baseURI) -> {
            try {
                InputSource input = resolverChain.resolveEntity(publicId, systemId);
                if (input != null) {
                    return new InputSourceToLSInput(input);
                }
                return currentResolver.resolveResource(type, namespaceURI, publicId, systemId, baseURI);
            }
            catch (IOException | SAXException e) {
                throw new RuntimeException("Could not resolve with entity resolver", e);
            }
        });
        validator.setErrorHandler(customErrorHandler);
        return validator;
    }

    private static class InputSourceToLSInput
    implements LSInput {
        private InputSource source;

        private InputSourceToLSInput(InputSource source) {
            this.source = source;
        }

        @Override
        public Reader getCharacterStream() {
            return this.source.getCharacterStream();
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
            this.source.setCharacterStream(characterStream);
        }

        @Override
        public InputStream getByteStream() {
            return this.source.getByteStream();
        }

        @Override
        public void setByteStream(InputStream byteStream) {
            this.source.setByteStream(byteStream);
        }

        @Override
        public String getStringData() {
            return null;
        }

        @Override
        public void setStringData(String stringData) {
        }

        @Override
        public String getSystemId() {
            return this.source.getSystemId();
        }

        @Override
        public void setSystemId(String systemId) {
            this.source.setSystemId(systemId);
        }

        @Override
        public String getPublicId() {
            return this.source.getPublicId();
        }

        @Override
        public void setPublicId(String publicId) {
            this.source.setPublicId(publicId);
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public void setBaseURI(String baseURI) {
        }

        @Override
        public String getEncoding() {
            return this.source.getEncoding();
        }

        @Override
        public void setEncoding(String encoding) {
            this.source.setEncoding(encoding);
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }
    }
}

