/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.configuration;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import javax.sql.DataSource;
import org.liquigraph.core.configuration.ConnectionConfiguration;
import org.liquigraph.core.exception.Throwables;

public class ConnectionConfigurationByDataSource
implements ConnectionConfiguration {
    private final DataSource dataSource;
    private final Optional<String> username;
    private final Optional<String> password;

    public ConnectionConfigurationByDataSource(DataSource dataSource, Optional<String> username, Optional<String> password) {
        this.dataSource = dataSource;
        this.username = username;
        this.password = password;
    }

    @Override
    public Connection get() {
        try {
            return this.connection();
        }
        catch (SQLException e) {
            throw Throwables.propagate(e);
        }
    }

    private Connection connection() throws SQLException {
        if (!this.username.isPresent()) {
            return this.dataSource.getConnection();
        }
        return this.dataSource.getConnection(this.username.get(), this.password.orElse(""));
    }
}

