/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.configuration;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import javax.sql.DataSource;
import org.liquigraph.core.configuration.Configuration;
import org.liquigraph.core.configuration.ConnectionConfiguration;
import org.liquigraph.core.configuration.ConnectionConfigurationByDataSource;
import org.liquigraph.core.configuration.ConnectionConfigurationByUri;
import org.liquigraph.core.configuration.DryRunMode;
import org.liquigraph.core.configuration.ExecutionContexts;
import org.liquigraph.core.configuration.ExecutionMode;
import org.liquigraph.core.configuration.RunMode;
import org.liquigraph.core.configuration.validators.DatasourceConfigurationValidator;
import org.liquigraph.core.configuration.validators.ExecutionModeValidator;
import org.liquigraph.core.configuration.validators.MandatoryOptionValidator;
import org.liquigraph.core.configuration.validators.UserCredentialsOptionValidator;
import org.liquigraph.core.io.xml.ChangelogLoader;
import org.liquigraph.core.io.xml.ClassLoaderChangelogLoader;

public final class ConfigurationBuilder {
    private String masterChangelog;
    private Optional<DataSource> dataSource = Optional.empty();
    private Optional<String> uri = Optional.empty();
    private Optional<String> database = Optional.empty();
    private Optional<String> username = Optional.empty();
    private Optional<String> password = Optional.empty();
    private ExecutionContexts executionContexts = ExecutionContexts.DEFAULT_CONTEXT;
    private ExecutionMode executionMode;
    private MandatoryOptionValidator mandatoryOptionValidator = new MandatoryOptionValidator();
    private DatasourceConfigurationValidator datasourceConnectionValidator = new DatasourceConfigurationValidator();
    private ExecutionModeValidator executionModeValidator = new ExecutionModeValidator();
    private UserCredentialsOptionValidator userCredentialsOptionValidator = new UserCredentialsOptionValidator();
    private ChangelogLoader changelogLoader = ClassLoaderChangelogLoader.currentThreadContextClassLoader();

    public ConfigurationBuilder withMasterChangelogLocation(String masterChangelog) {
        this.masterChangelog = masterChangelog;
        return this;
    }

    public ConfigurationBuilder withUri(String uri) {
        this.uri = Optional.ofNullable(uri);
        return this;
    }

    public ConfigurationBuilder withDataSource(DataSource dataSource) {
        this.dataSource = Optional.ofNullable(dataSource);
        return this;
    }

    public ConfigurationBuilder withDatabase(String database) {
        this.database = Optional.ofNullable(database);
        return this;
    }

    public ConfigurationBuilder withUsername(String username) {
        this.username = Optional.ofNullable(username);
        return this;
    }

    public ConfigurationBuilder withPassword(String password) {
        this.password = Optional.ofNullable(password);
        return this;
    }

    public ConfigurationBuilder withExecutionContexts(String ... executionContexts) {
        return this.withExecutionContexts(Arrays.asList(executionContexts));
    }

    public ConfigurationBuilder withExecutionContexts(Collection<String> executionContexts) {
        if (!executionContexts.isEmpty()) {
            this.executionContexts = new ExecutionContexts(executionContexts);
        }
        return this;
    }

    public ConfigurationBuilder withRunMode() {
        this.executionMode = RunMode.RUN_MODE;
        return this;
    }

    public ConfigurationBuilder withDryRunMode(Path outputDirectory) {
        this.executionMode = new DryRunMode(outputDirectory);
        return this;
    }

    @Deprecated
    public ConfigurationBuilder withClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            this.changelogLoader = new ClassLoaderChangelogLoader(classLoader);
        }
        return this;
    }

    public ConfigurationBuilder withChangelogLoader(ChangelogLoader changelogLoader) {
        if (changelogLoader != null) {
            this.changelogLoader = changelogLoader;
        }
        return this;
    }

    public Configuration build() {
        ArrayList<String> errors = new ArrayList<String>();
        errors.addAll(this.mandatoryOptionValidator.validate(this.changelogLoader, this.masterChangelog));
        errors.addAll(this.datasourceConnectionValidator.validate(this.uri, this.dataSource, this.database));
        errors.addAll(this.executionModeValidator.validate(this.executionMode));
        errors.addAll(this.userCredentialsOptionValidator.validate((String)this.username.orElse(null), (String)this.password.orElse(null)));
        if (!errors.isEmpty()) {
            throw new RuntimeException(this.formatErrors(errors));
        }
        return new Configuration(this.changelogLoader, this.masterChangelog, this.dataSourceConfiguration(), this.executionContexts, this.executionMode, this.database.orElse(null));
    }

    private ConnectionConfiguration dataSourceConfiguration() {
        if (this.uri.isPresent()) {
            return new ConnectionConfigurationByUri(this.uri.get(), this.database, this.username, this.password);
        }
        return new ConnectionConfigurationByDataSource(this.dataSource.get(), this.username, this.password);
    }

    private String formatErrors(Collection<String> errors) {
        String separator = "\n\t - ";
        return String.format("%s%s", separator, String.join((CharSequence)separator, errors));
    }
}

