/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.api;

import org.liquigraph.core.api.ChangelogDiffMaker;
import org.liquigraph.core.api.LiquigraphApi;
import org.liquigraph.core.api.MigrationRunner;
import org.liquigraph.core.configuration.Configuration;
import org.liquigraph.core.io.ChangelogGraphReader;
import org.liquigraph.core.io.ConditionExecutor;
import org.liquigraph.core.io.ConditionPrinter;
import org.liquigraph.core.io.xml.ChangelogParser;
import org.liquigraph.core.io.xml.ChangelogPreprocessor;
import org.liquigraph.core.io.xml.ImportResolver;
import org.liquigraph.core.io.xml.XmlSchemaValidator;
import org.liquigraph.core.validation.PersistedChangesetValidator;

public final class Liquigraph
implements LiquigraphApi {
    private final MigrationRunner migrationRunner = Liquigraph.migrationRunner(Liquigraph.changelogParser(Liquigraph.xmlSchemaValidator(), Liquigraph.changelogPreprocessor(Liquigraph.importResolver())), Liquigraph.changelogGraphReader(), Liquigraph.changelogDiffMaker(), Liquigraph.conditionExecutor(), Liquigraph.conditionPrinter());

    private static MigrationRunner migrationRunner(ChangelogParser changelogParser, ChangelogGraphReader changelogGraphReader, ChangelogDiffMaker changelogDiffMaker, ConditionExecutor conditionExecutor, ConditionPrinter conditionPrinter) {
        return new MigrationRunner(changelogParser, changelogGraphReader, changelogDiffMaker, conditionExecutor, conditionPrinter, Liquigraph.persistedChangesetValidator());
    }

    private static PersistedChangesetValidator persistedChangesetValidator() {
        return new PersistedChangesetValidator();
    }

    private static ConditionPrinter conditionPrinter() {
        return new ConditionPrinter();
    }

    private static ConditionExecutor conditionExecutor() {
        return new ConditionExecutor();
    }

    private static ChangelogDiffMaker changelogDiffMaker() {
        return new ChangelogDiffMaker();
    }

    private static ChangelogGraphReader changelogGraphReader() {
        return new ChangelogGraphReader();
    }

    private static ChangelogParser changelogParser(XmlSchemaValidator validator, ChangelogPreprocessor preprocessor) {
        return new ChangelogParser(validator, preprocessor);
    }

    private static ChangelogPreprocessor changelogPreprocessor(ImportResolver resolver) {
        return new ChangelogPreprocessor(resolver);
    }

    private static ImportResolver importResolver() {
        return new ImportResolver();
    }

    private static XmlSchemaValidator xmlSchemaValidator() {
        return new XmlSchemaValidator();
    }

    @Override
    public void runMigrations(Configuration configuration) {
        this.migrationRunner.runMigrations(configuration);
    }
}

