/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.model.predicates;

import java.util.function.Predicate;
import org.liquigraph.core.exception.Preconditions;
import org.liquigraph.core.model.Changeset;

public class ChangesetById
implements Predicate<Changeset> {
    private final String id;
    private final String author;

    private ChangesetById(String id, String author) {
        this.id = id;
        this.author = author;
        Preconditions.checkState(id != null);
        Preconditions.checkState(author != null);
    }

    public static Predicate<Changeset> BY_ID(String id, String author) {
        return new ChangesetById(id, author);
    }

    @Override
    public boolean test(Changeset input) {
        return this.id.equals(input.getId()) && this.author.equals(input.getAuthor());
    }
}

