/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.configuration;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import org.liquigraph.core.model.predicates.ExecutionContextsMatchAnyContext;

public class ExecutionContexts {
    public static final ExecutionContexts DEFAULT_CONTEXT = new ExecutionContexts(Optional.empty());
    private Predicate<String> anyContext;

    public ExecutionContexts(Collection<String> executionContexts) {
        this(Optional.ofNullable(executionContexts));
    }

    private ExecutionContexts(Optional<Collection<String>> contexts) {
        this.anyContext = ExecutionContextsMatchAnyContext.BY_ANY_CONTEXT(contexts);
    }

    public boolean matches(Optional<Collection<String>> declaredContexts) {
        if (!declaredContexts.isPresent()) {
            return true;
        }
        Collection<String> changesetContexts = declaredContexts.get();
        if (changesetContexts.isEmpty()) {
            return true;
        }
        return changesetContexts.stream().anyMatch(this.anyContext);
    }
}

