/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.api;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.function.Supplier;
import org.liquigraph.core.api.ChangelogDiffMaker;
import org.liquigraph.core.configuration.Configuration;
import org.liquigraph.core.io.ChangelogGraphReader;
import org.liquigraph.core.io.ChangelogWriter;
import org.liquigraph.core.io.ConditionExecutor;
import org.liquigraph.core.io.ConditionPrinter;
import org.liquigraph.core.io.GraphJdbcConnector;
import org.liquigraph.core.io.xml.ChangelogLoader;
import org.liquigraph.core.io.xml.ChangelogParser;
import org.liquigraph.core.model.Changeset;
import org.liquigraph.core.validation.PersistedChangesetValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MigrationRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationRunner.class);
    private final ChangelogParser changelogParser;
    private final ChangelogGraphReader changelogReader;
    private final ChangelogDiffMaker changelogDiffMaker;
    private final ConditionExecutor conditionExecutor;
    private final ConditionPrinter conditionPrinter;
    private final PersistedChangesetValidator persistedChangesetValidator;

    public MigrationRunner(ChangelogParser changelogParser, ChangelogGraphReader changelogGraphReader, ChangelogDiffMaker changelogDiffMaker, ConditionExecutor conditionExecutor, ConditionPrinter conditionPrinter, PersistedChangesetValidator persistedChangesetValidator) {
        this.changelogParser = changelogParser;
        this.changelogReader = changelogGraphReader;
        this.changelogDiffMaker = changelogDiffMaker;
        this.conditionExecutor = conditionExecutor;
        this.conditionPrinter = conditionPrinter;
        this.persistedChangesetValidator = persistedChangesetValidator;
    }

    public void runMigrations(Configuration configuration) {
        Collection<Changeset> declaredChangesets = this.parseChangesets(configuration.changelogLoader(), configuration.masterChangelog());
        ConnectionSupplier connectionSupplier = new ConnectionSupplier(new GraphJdbcConnector(configuration));
        try (Connection writeConnection = (Connection)connectionSupplier.get();){
            Collection<Changeset> persistedChangesets = this.readPersistedChangesets(declaredChangesets, writeConnection);
            Collection<Changeset> changelog = this.changelogDiffMaker.computeChangesetsToInsert(configuration.executionContexts(), declaredChangesets, persistedChangesets);
            this.writeApplicableChangesets(configuration, writeConnection, connectionSupplier, changelog);
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private Collection<Changeset> parseChangesets(ChangelogLoader changelogLoader, String masterChangelog) {
        return this.changelogParser.parse(changelogLoader, masterChangelog);
    }

    private Collection<Changeset> readPersistedChangesets(Collection<Changeset> declaredChangesets, Connection writeConnection) {
        Collection<Changeset> persistedChangesets = this.changelogReader.read(writeConnection);
        Collection<String> errors = this.persistedChangesetValidator.validate(declaredChangesets, persistedChangesets);
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(this.formatErrorMessage(errors));
        }
        return persistedChangesets;
    }

    private void writeApplicableChangesets(Configuration configuration, Connection writeConnection, Supplier<Connection> connectionSupplier, Collection<Changeset> changelogsToInsert) {
        ChangelogWriter changelogWriter = configuration.resolveWriter(writeConnection, connectionSupplier, this.conditionExecutor, this.conditionPrinter);
        changelogWriter.write(changelogsToInsert);
    }

    private String formatErrorMessage(Collection<String> errors) {
        String separator = "\n\t";
        return separator + String.join((CharSequence)separator, errors);
    }

    private static class ConnectionSupplier
    implements Supplier<Connection> {
        private final GraphJdbcConnector connector;

        public ConnectionSupplier(GraphJdbcConnector connector) {
            this.connector = connector;
        }

        @Override
        public Connection get() {
            return this.connector.connect();
        }
    }
}

