/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.io.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.liquigraph.core.exception.Throwables;
import org.liquigraph.core.io.xml.ChangelogLoader;
import org.liquigraph.core.io.xml.IterableNodeList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ImportResolver {
    private final XPath xpath = XPathFactory.newInstance().newXPath();

    public Node resolveImports(String changelog, ChangelogLoader changelogLoader) {
        Node node;
        block9: {
            InputStream stream = changelogLoader.load(changelog);
            try {
                if (stream == null) {
                    throw new RuntimeException("Import location cannot be resolved: " + changelog);
                }
                node = this.resolve(changelog, this.document(stream), changelogLoader);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Throwables.propagate(e);
                }
            }
            stream.close();
        }
        return node;
    }

    private Node resolve(String changelog, Document document, ChangelogLoader changelogLoader) {
        Element root = document.getDocumentElement();
        IterableNodeList imports = IterableNodeList.of(this.evaluateNodes("/changelog/import", root));
        for (Node toImport : imports) {
            String fullPath = this.parentFolder(changelog) + ImportResolver.attributeTextContent(toImport, "resource");
            Node resolvedRoot = this.resolveImports(fullPath, changelogLoader);
            IterableNodeList changesets = IterableNodeList.of(this.evaluateNodes("/changelog/changeset", resolvedRoot));
            for (Node changeset : changesets) {
                Node importedChangeset = document.importNode(changeset, true);
                root.insertBefore(importedChangeset, toImport);
            }
            root.removeChild(toImport);
        }
        return root;
    }

    private String parentFolder(String changelog) {
        return changelog.substring(0, changelog.lastIndexOf(47) + 1);
    }

    private Document document(InputStream changelog) {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(changelog);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw Throwables.propagate(e);
        }
    }

    private static String attributeTextContent(Node legalImport, String attributeName) {
        return legalImport.getAttributes().getNamedItem(attributeName).getTextContent();
    }

    private NodeList evaluateNodes(String expression, Node document) {
        try {
            return (NodeList)this.xpath.evaluate(expression, document.getOwnerDocument(), XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw Throwables.propagate(e);
        }
    }
}

