/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.io.xml;

import javax.xml.transform.dom.DOMSource;
import org.liquigraph.core.io.xml.DomSourceValidator;
import org.liquigraph.core.io.xml.ExplicitSchemaValidator;
import org.liquigraph.core.io.xml.ImplicitSchemaValidator;
import org.liquigraph.core.io.xml.SchemaDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomSourceValidatorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DomSourceValidatorFactory.class);
    private final SchemaDetector schemaDetector = new SchemaDetector();

    public DomSourceValidator createValidator(DOMSource source) {
        if (this.schemaDetector.hasExplicitSchema(source)) {
            LOGGER.debug("Explicit schema detected: validation against schema to start");
            return new ExplicitSchemaValidator();
        }
        LOGGER.debug("No schema detected: validation against embedded schema to start");
        return new ImplicitSchemaValidator();
    }
}

