/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.io.xml;

import java.util.Collection;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.liquigraph.core.io.xml.ChangelogLoader;
import org.liquigraph.core.io.xml.ChangelogPreprocessor;
import org.liquigraph.core.io.xml.XmlSchemaValidator;
import org.liquigraph.core.model.Changelog;
import org.liquigraph.core.model.Changeset;
import org.w3c.dom.Node;

public final class ChangelogParser {
    private static final String SEPARATOR = System.lineSeparator() + "\t";
    private final ChangelogPreprocessor preprocessor;
    private final Unmarshaller unmarshaller;
    private final XmlSchemaValidator validator;

    public ChangelogParser(XmlSchemaValidator validator, ChangelogPreprocessor preprocessor) {
        this.validator = validator;
        this.preprocessor = preprocessor;
        try {
            this.unmarshaller = JAXBContext.newInstance((Class[])new Class[]{Changelog.class}).createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public Collection<Changeset> parse(ChangelogLoader changelogLoader, String masterChangelog) {
        return this.parseChangelog(changelogLoader, masterChangelog).getChangesets();
    }

    private Changelog parseChangelog(ChangelogLoader changelogLoader, String masterChangelog) {
        try {
            Node document = this.preprocessor.preProcess(masterChangelog, changelogLoader);
            Collection<String> errors = this.validator.validateSchema(document);
            if (!errors.isEmpty()) {
                throw new IllegalArgumentException(this.formatErrorMessage(errors));
            }
            Changelog changelog = (Changelog)this.unmarshaller.unmarshal(document);
            this.fixUpChangesets(changelog);
            return changelog;
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException(String.format("Unable to parse changelog <%s>.", masterChangelog), e);
        }
    }

    private void fixUpChangesets(Changelog changelog) {
        for (Changeset changeset : changelog.getChangesets()) {
            changeset.setQueries(changeset.getQueries());
        }
    }

    private String formatErrorMessage(Collection<String> errors) {
        return SEPARATOR + String.join((CharSequence)SEPARATOR, errors);
    }
}

