/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.io;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.liquigraph.core.exception.ConditionExecutionException;
import org.liquigraph.core.exception.Preconditions;
import org.liquigraph.core.model.CompoundQuery;
import org.liquigraph.core.model.Condition;
import org.liquigraph.core.model.Query;
import org.liquigraph.core.model.SimpleQuery;
import org.neo4j.driver.exceptions.ClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionExecutor {
    private final Logger logger = LoggerFactory.getLogger(ConditionExecutor.class);

    public final boolean executeCondition(Connection connection, Condition condition) {
        Preconditions.checkArgument(connection != null, "Connection should not be null");
        return this.applyPrecondition(connection, condition.getQuery());
    }

    private boolean applyPrecondition(Connection connection, Query query) {
        if (query instanceof SimpleQuery) {
            SimpleQuery simpleQuery = (SimpleQuery)query;
            return this.execute(connection, simpleQuery.getQuery());
        }
        if (query instanceof CompoundQuery) {
            CompoundQuery compoundQuery = (CompoundQuery)query;
            return compoundQuery.compose(this.applyPrecondition(connection, compoundQuery.getFirstQuery()), this.applyPrecondition(connection, compoundQuery.getSecondQuery()));
        }
        throw new IllegalArgumentException(String.format("Unsupported query type <%s>", query.getClass().getName()));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean execute(Connection connection, String query) {
        try (Statement statement = connection.createStatement();){
            boolean bl;
            block14: {
                ResultSet resultSet = statement.executeQuery(query);
                try {
                    this.logger.debug("Executed condition: {}", (Object)query);
                    resultSet.next();
                    bl = resultSet.getBoolean("result");
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return bl;
        }
        catch (SQLException | ClientException e) {
            throw new ConditionExecutionException(e, "\nError executing condition:\n\tMake sure your query <%s> yields exactly one column named or aliased 'result'.\n\tActual cause: %s", query, e.getMessage());
        }
    }
}

