/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.io;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.liquigraph.core.exception.PreconditionNotMetException;
import org.liquigraph.core.exception.Throwables;
import org.liquigraph.core.io.ChangelogWriter;
import org.liquigraph.core.io.ConditionExecutor;
import org.liquigraph.core.model.Changeset;
import org.liquigraph.core.model.Condition;
import org.liquigraph.core.model.Postcondition;
import org.liquigraph.core.model.Precondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangelogGraphWriter
implements ChangelogWriter {
    private static final String CHANGESET_UPSERT = "MERGE (changelog:__LiquigraphChangelog) MERGE (changelog)<-[ewc:EXECUTED_WITHIN_CHANGELOG]-(changeset:__LiquigraphChangeset {id: ?, author: ?}) ON MATCH SET  changeset.checksum = ? ON CREATE SET changeset.checksum = ?,               ewc.time = timestamp() WITH changeset OPTIONAL MATCH (changeset)<-[eq:EXECUTED_WITHIN_CHANGESET]-(query:__LiquigraphQuery) DELETE eq, query RETURN changeset ";
    private static final String QUERY_UPSERT = "MATCH (changeset:__LiquigraphChangeset {id: ?, author: ?}) CREATE (changeset)<-[:EXECUTED_WITHIN_CHANGESET {`order`:?}]-(:__LiquigraphQuery {query: ?})";
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangelogGraphWriter.class);
    private final Connection writeConnection;
    private final Supplier<Connection> connectionSupplier;
    private final ConditionExecutor conditionExecutor;

    public ChangelogGraphWriter(Connection writeConnection, Supplier<Connection> connectionSupplier, ConditionExecutor conditionExecutor) {
        this.writeConnection = writeConnection;
        this.connectionSupplier = connectionSupplier;
        this.conditionExecutor = conditionExecutor;
    }

    @Override
    public void write(Collection<Changeset> changelog) {
        for (Changeset changeset : changelog) {
            StatementExecution statementExecution = this.executeStatement(changeset);
            if (statementExecution == StatementExecution.IGNORE_FAILURE) continue;
            this.insertChangeset(changeset);
        }
    }

    private StatementExecution executeStatement(Changeset changeset) {
        try {
            Postcondition postcondition;
            boolean postConditionApplies;
            Precondition precondition = changeset.getPrecondition();
            if (precondition != null && !this.executeCondition(precondition)) {
                LOGGER.warn("Precondition of changeset ID {} by {} failed", (Object)changeset.getId(), (Object)changeset.getAuthor());
                return ChangelogGraphWriter.handleFailedPrecondition(precondition, changeset);
            }
            do {
                LOGGER.info("Executing postcondition of changeset ID {} by {}", (Object)changeset.getId(), (Object)changeset.getAuthor());
                this.executeChangesetQueries(changeset.getQueries());
            } while (postConditionApplies = (postcondition = changeset.getPostcondition()) != null && this.executeCondition(postcondition));
        }
        catch (SQLException e) {
            LOGGER.error("Changeset ID {} by {} failed to execute", new Object[]{changeset.getId(), changeset.getAuthor(), e});
            throw Throwables.propagate(e);
        }
        LOGGER.info("Changeset ID {} by {} was just executed", (Object)changeset.getId(), (Object)changeset.getAuthor());
        return StatementExecution.SUCCESS;
    }

    private void executeChangesetQueries(Collection<String> queries) throws SQLException {
        try (Statement statement = this.writeConnection.createStatement();){
            for (String query : queries) {
                statement.execute(query);
                LOGGER.debug("Executing query: {}", (Object)query);
            }
            this.writeConnection.commit();
            LOGGER.debug("Committing transaction");
        }
    }

    private static StatementExecution handleFailedPrecondition(Precondition precondition, Changeset changeset) {
        switch (precondition.getPolicy()) {
            case MARK_AS_EXECUTED: {
                LOGGER.info("Skipping execution of changeset {} by {} but marking as executed", (Object)changeset.getId(), (Object)changeset.getAuthor());
                return StatementExecution.SUCCESS;
            }
            case CONTINUE: {
                LOGGER.info("Ignoring precondition failure of changeset {} by {}", (Object)changeset.getId(), (Object)changeset.getAuthor());
                return StatementExecution.IGNORE_FAILURE;
            }
            case FAIL: {
                LOGGER.info("Failing precondition of changeset {} by {}. Aborting now.", (Object)changeset.getId(), (Object)changeset.getAuthor());
                throw new PreconditionNotMetException(String.format("Changeset id=<%s>, author=<%s>: precondition query %s failed with policy <%s>. Aborting.", new Object[]{changeset.getId(), changeset.getAuthor(), precondition.getQuery(), precondition.getPolicy()}));
            }
        }
        throw new IllegalArgumentException(String.format("Changeset id=<%s>, author=<%s>: unsupported policy <%s>. Aborting.", new Object[]{changeset.getId(), changeset.getAuthor(), precondition.getPolicy()}));
    }

    private boolean executeCondition(Condition condition) {
        boolean bl;
        block8: {
            Connection readConnection = this.connectionSupplier.get();
            try {
                boolean conditionResult = this.conditionExecutor.executeCondition(readConnection, condition);
                readConnection.rollback();
                bl = conditionResult;
                if (readConnection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (readConnection != null) {
                        try {
                            readConnection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw Throwables.propagate(e);
                }
            }
            readConnection.close();
        }
        return bl;
    }

    private void insertChangeset(Changeset changeset) {
        try (PreparedStatement changesetUpsertStatement = this.writeConnection.prepareStatement(CHANGESET_UPSERT);
             PreparedStatement queryUpsertStatement = this.writeConnection.prepareStatement(QUERY_UPSERT);){
            String id = changeset.getId();
            String author = changeset.getAuthor();
            String checksum = changeset.getChecksum();
            changesetUpsertStatement.setString(1, id);
            changesetUpsertStatement.setString(2, author);
            changesetUpsertStatement.setString(3, checksum);
            changesetUpsertStatement.setString(4, checksum);
            changesetUpsertStatement.execute();
            queryUpsertStatement.setString(1, id);
            queryUpsertStatement.setString(2, author);
            Collection<String> queries = changeset.getQueries();
            for (int order = 0; order < queries.size(); ++order) {
                queryUpsertStatement.setInt(3, order);
                queryUpsertStatement.setString(4, this.getNth(queries, order));
                queryUpsertStatement.execute();
            }
            this.writeConnection.commit();
        }
        catch (SQLException e) {
            throw Throwables.propagate(e);
        }
    }

    private <T> T getNth(Collection<T> items, int index) {
        int i = 0;
        for (T item : items) {
            if (i++ != index) continue;
            return item;
        }
        throw new NoSuchElementException(String.format("element %d not found", index));
    }

    private static enum StatementExecution {
        SUCCESS,
        IGNORE_FAILURE;

    }
}

