/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.configuration.validators;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import javax.sql.DataSource;

public class DatasourceConfigurationValidator {
    public Collection<String> validate(Optional<String> uri, Optional<DataSource> dataSource) {
        if (uri.isPresent() == dataSource.isPresent()) {
            return Collections.singletonList("Exactly one of JDBC URI or DataSource need to be configured");
        }
        return uri.map(DatasourceConfigurationValidator::validateConnectionString).orElse(Collections.emptyList());
    }

    private static Collection<String> validateConnectionString(String uri) {
        LinkedList<String> errors = new LinkedList<String>();
        if (!uri.startsWith("jdbc:neo4j:http") && !uri.startsWith("jdbc:neo4j:bolt")) {
            errors.add(String.format("Invalid JDBC URI. Supported configurations:%n\t - jdbc:neo4j:http(s)://<host>:<port>/%n\t - jdbc:neo4j:bolt://<host>:<port>/%nGiven: %s", uri));
        }
        return errors;
    }
}

