/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.configuration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Optional;
import org.liquigraph.core.configuration.ConnectionConfiguration;
import org.liquigraph.core.exception.Throwables;

public class ConnectionConfigurationByUri
implements ConnectionConfiguration {
    private final String uri;
    private final Optional<String> username;
    private final Optional<String> password;
    private final UriConnectionSupplier connectionSupplier;

    public ConnectionConfigurationByUri(String uri, Optional<String> username, Optional<String> password) {
        this(uri, username, password, DefaultUriConnectionSupplier.INSTANCE);
    }

    ConnectionConfigurationByUri(String uri, Optional<String> username, Optional<String> password, UriConnectionSupplier connectionSupplier) {
        this.uri = uri;
        this.username = username;
        this.password = password;
        this.connectionSupplier = connectionSupplier;
    }

    @Override
    public Connection get() {
        if (this.username.isPresent()) {
            return this.connectionSupplier.getConnection(this.uri, this.username.get(), this.password.orElse(""));
        }
        return this.connectionSupplier.getConnection(this.uri);
    }

    static interface UriConnectionSupplier {
        public Connection getConnection(String var1);

        public Connection getConnection(String var1, String var2, String var3);
    }

    private static enum DefaultUriConnectionSupplier implements UriConnectionSupplier
    {
        INSTANCE;


        @Override
        public Connection getConnection(String uri) {
            try {
                return DriverManager.getConnection(uri);
            }
            catch (SQLException e) {
                throw Throwables.propagate(e);
            }
        }

        @Override
        public Connection getConnection(String uri, String username, String password) {
            try {
                return DriverManager.getConnection(uri, username, password);
            }
            catch (SQLException e) {
                throw Throwables.propagate(e);
            }
        }
    }
}

