/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.configuration;

import java.sql.Connection;
import java.util.function.Supplier;
import org.liquigraph.core.configuration.ConnectionConfiguration;
import org.liquigraph.core.configuration.DryRunMode;
import org.liquigraph.core.configuration.ExecutionContexts;
import org.liquigraph.core.configuration.ExecutionMode;
import org.liquigraph.core.configuration.RunMode;
import org.liquigraph.core.io.ChangelogFileWriter;
import org.liquigraph.core.io.ChangelogGraphWriter;
import org.liquigraph.core.io.ChangelogWriter;
import org.liquigraph.core.io.ConditionExecutor;
import org.liquigraph.core.io.ConditionPrinter;
import org.liquigraph.core.io.xml.ChangelogLoader;
import org.liquigraph.core.io.xml.ClassLoaderChangelogLoader;

public final class Configuration {
    private final ChangelogLoader changelogLoader;
    private final String masterChangelog;
    private final ConnectionConfiguration connectionConfiguration;
    private final ExecutionContexts executionContexts;
    private final ExecutionMode executionMode;

    Configuration(ChangelogLoader changelogLoader, String masterChangelog, ConnectionConfiguration connectionConfiguration, ExecutionContexts executionContexts, ExecutionMode executionMode) {
        this.changelogLoader = changelogLoader;
        this.masterChangelog = masterChangelog;
        this.connectionConfiguration = connectionConfiguration;
        this.executionContexts = executionContexts;
        this.executionMode = executionMode;
    }

    @Deprecated
    public ClassLoader classLoader() {
        if (this.changelogLoader instanceof ClassLoaderChangelogLoader) {
            return ((ClassLoaderChangelogLoader)this.changelogLoader).getClassLoader();
        }
        return null;
    }

    public ChangelogLoader changelogLoader() {
        return this.changelogLoader;
    }

    public String masterChangelog() {
        return this.masterChangelog;
    }

    public ConnectionConfiguration dataSourceConfiguration() {
        return this.connectionConfiguration;
    }

    public ExecutionContexts executionContexts() {
        return this.executionContexts;
    }

    public ExecutionMode executionMode() {
        return this.executionMode;
    }

    public ChangelogWriter resolveWriter(Connection writeConnection, Supplier<Connection> connectionSupplier, ConditionExecutor conditionExecutor, ConditionPrinter conditionPrinter) {
        ExecutionMode executionMode = this.executionMode();
        if (executionMode == RunMode.RUN_MODE) {
            return new ChangelogGraphWriter(writeConnection, connectionSupplier, conditionExecutor);
        }
        if (executionMode instanceof DryRunMode) {
            DryRunMode dryRunMode = (DryRunMode)executionMode;
            return new ChangelogFileWriter(conditionPrinter, dryRunMode.getOutputFile());
        }
        throw new IllegalStateException("Unsupported <executionMode>: " + executionMode);
    }
}

