/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.io.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.liquigraph.core.io.xml.DomSourceValidator;
import org.liquigraph.core.io.xml.SchemaErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

class ExplicitSchemaValidator
implements DomSourceValidator {
    private final SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();

    public ExplicitSchemaValidator() {
        this.saxParserFactory.setValidating(true);
        this.saxParserFactory.setNamespaceAware(true);
    }

    @Override
    public Collection<String> validate(DOMSource changelog) throws Exception {
        SchemaErrorHandler errorHandler = new SchemaErrorHandler();
        XMLReader reader = this.saxParser().getXMLReader();
        reader.setErrorHandler(errorHandler);
        this.parse(changelog, reader);
        return errorHandler.getErrors();
    }

    private SAXParser saxParser() throws ParserConfigurationException, SAXException {
        SAXParser saxParser = this.saxParserFactory.newSAXParser();
        try {
            saxParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            // empty catch block
        }
        return saxParser;
    }

    private void parse(DOMSource changelog, XMLReader reader) throws IOException, TransformerException, SAXException {
        try (StringWriter writer = new StringWriter();){
            StreamResult result = new StreamResult(writer);
            TransformerFactory.newInstance().newTransformer().transform(changelog, result);
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(writer.toString().getBytes("UTF-8"));){
                reader.parse(new InputSource(inputStream));
            }
        }
    }
}

