/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.io;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import org.liquigraph.core.model.CompoundQuery;
import org.liquigraph.core.model.Condition;
import org.liquigraph.core.model.Query;
import org.liquigraph.core.model.SimpleQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionExecutor {
    private final Logger logger = LoggerFactory.getLogger(ConditionExecutor.class);

    public final boolean executeCondition(Connection connection, Condition condition) {
        Preconditions.checkArgument((connection != null ? 1 : 0) != 0, (Object)"Connection should not be null");
        return this.applyPrecondition(connection, condition.getQuery());
    }

    private boolean applyPrecondition(Connection connection, Query query) {
        if (query instanceof SimpleQuery) {
            SimpleQuery simpleQuery = (SimpleQuery)query;
            return this.execute(connection, simpleQuery.getQuery());
        }
        if (query instanceof CompoundQuery) {
            CompoundQuery compoundQuery = (CompoundQuery)query;
            return compoundQuery.compose(this.applyPrecondition(connection, compoundQuery.getFirstQuery()), this.applyPrecondition(connection, compoundQuery.getSecondQuery()));
        }
        throw new IllegalArgumentException(String.format("Unsupported query type <%s>", query.getClass().getName()));
    }

    /*
     * Exception decompiling
     */
    private boolean execute(Connection connection, String query) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

