/*
 * Decompiled with CFR 0.152.
 */
package org.liquigraph.core.io;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.liquigraph.core.io.ChangelogFileWriter;
import org.liquigraph.core.model.Changeset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangelogGraphReader {
    private static final String MIGRATE_PRE_1_0_RC3_CHANGELOG = "MATCH (:__LiquigraphChangelog)<-[exec:EXECUTED_WITHIN_CHANGELOG]-(changeset:__LiquigraphChangeset) WHERE EXISTS(exec.`order`) AND EXISTS(changeset.query) SET exec.time = exec.`order` WITH exec, changeset REMOVE exec.`order` WITH changeset CREATE (changeset)<-[:EXECUTED_WITHIN_CHANGESET {`order`: 0}]-(query:__LiquigraphQuery) SET query.query = changeset.query WITH changeset REMOVE changeset.query";
    private static final String MATCH_CHANGESETS = "MATCH (:__LiquigraphChangelog)<-[:EXECUTED_WITHIN_CHANGELOG]-(changeset:__LiquigraphChangeset),       (changeset)<-[execChangeSet:EXECUTED_WITHIN_CHANGESET]-(query:__LiquigraphQuery) WITH changeset, query ORDER BY execChangeSet.`order` ASC WITH changeset, COLLECT(query.query) AS queries RETURN {   id: changeset.id,    author:changeset.author,    checksum:changeset.checksum,    query:queries} AS changeset";
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangelogFileWriter.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Collection<Changeset> read(Connection connection) {
        ArrayList changesets = Lists.newArrayList();
        try (Statement statement = connection.createStatement();){
            LOGGER.debug("Migrating pre 1.0-RC3 history graph");
            statement.execute(MIGRATE_PRE_1_0_RC3_CHANGELOG);
            try (ResultSet result = statement.executeQuery(MATCH_CHANGESETS);){
                while (result.next()) {
                    changesets.add(this.mapRow(result.getObject("changeset")));
                }
            }
            connection.commit();
            LOGGER.debug("Retrieved {} changesets", (Object)changesets.size());
            ArrayList arrayList = changesets;
            return arrayList;
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Changeset mapRow(Object line) throws SQLException {
        if (line instanceof Map) {
            return this.changeset((Map)line);
        }
        throw new IllegalArgumentException(String.format("Unsupported row.\n\tCannot parse: %s", line));
    }

    private Changeset changeset(Map<String, Object> node) {
        Changeset changeset = new Changeset();
        changeset.setAuthor(String.valueOf(node.get("author")));
        changeset.setId(String.valueOf(node.get("id")));
        changeset.setQueries(this.adaptQueries(node.get("query")));
        changeset.setChecksum(String.valueOf(node.get("checksum")));
        return changeset;
    }

    private Collection<String> adaptQueries(Object rawQuery) {
        return Collections.unmodifiableCollection((Collection)rawQuery);
    }
}

